package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;

public class ParsePatientSearchStringTest {
	private PatientSearchCriteria parseString(String s) {
		return SearchStringParser.parseSearchString(s);
	}

	@Test
	public void parseLastName() {
		String s = "last";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("last", p.getLastName());
		assertNull(p.getFirstName());
	}

	@Test
	public void parseLastNameWithSpaces() {
		String s = " last ";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("last", p.getLastName());
		assertNull(p.getFirstName());
	}

	@Test
	public void parseLastNameComma() {
		String s = "last,";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("last", p.getLastName());
		assertNull(p.getFirstName());
	}

	@Test
	public void parseCommaFirstName() {
		String s = ",first";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertNull(p.getLastName());
		assertEquals("first", p.getFirstName());
	}

	@Test
	public void parseLastNameCommaFirstName() {
		String s = "last,first";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("last", p.getLastName());
		assertEquals("first", p.getFirstName());
	}

	@Test
	public void parseExtractSpaceBeforeLastName() {
		String s = " last,first";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("last", p.getLastName());
		assertEquals("first", p.getFirstName());
	}

	@Test
	public void parseExtractSpaceAfterLastName() {
		String s = "last ,first";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("last", p.getLastName());
		assertEquals("first", p.getFirstName());
	}

	@Test
	public void parseExtractSpaceBeforeFirstName() {
		String s = "last, first";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("last", p.getLastName());
		assertEquals("first", p.getFirstName());
	}

	@Test
	public void parseExtractSpaceAfterFirstName() {
		String s = "last,first ";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("last", p.getLastName());
		assertEquals("first", p.getFirstName());
	}

	@Test
	public void parseExtractSpacesInName() {
		String s = " last , first ";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("last", p.getLastName());
		assertEquals("first", p.getFirstName());
	}

	@Test
	public void parseSsn() {
		String s = "123456789";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("123456789", p.getSsn());
		assertNull(p.getLastName());
		assertNull(p.getFirstName());
	}

	@Test
	public void parseNameWithSpaceInLastName() {
		String s = "von buran,first";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("von buran", p.getLastName());
		assertEquals("first", p.getFirstName());
	}

	@Test
	public void parseNameWithSpaceInFirstName() {
		String s = "last,ann marie";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("last", p.getLastName());
		assertEquals("ann marie", p.getFirstName());
	}

	@Test
	public void parseNameWithSpaceInBothName() {
		String s = "la lb,fa fb";
		PatientSearchCriteria criteria = parseString(s);
		Patient p = criteria.getPrototype();
		assertEquals("la lb", p.getLastName());
		assertEquals("fa fb", p.getFirstName());
	}
}
