package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.UUID;

import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientMetadata;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationMock;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientMetadataDataServiceTest {
	private final static PatientIdentifier patientIdentifier = PatientCorrelationMock.GallowEnterprisePatientIdentifier;
	private final static PatientIdentifier patientIdentifierWithNoData = PatientCorrelationMock.HealthyEnterprisePatientIdentifier;
	
	private PatientMetadataDataService dataservice = new PatientMetadataDataService();
	
	public PatientMetadataDataServiceTest() {
	
	}

	@BeforeClass
	public static void init() {
		Assume.assumeTrue(ModeHelper.isMode("dev", "va-veteran-dev"));
	}
	
	@Test
	public void testPatientMetadataByPatientId() {
		PatientMetadata patientMetadata = new PatientMetadata();
		Date now = new Date();
		patientMetadata.setPatientIdentifier(new PatientIdentifier("mock-aa", UUID.randomUUID().toString()));
		patientMetadata.setLastAppointmentRequestAccessDate(now);
		
		PatientMetadata savedMetadata = savePatientMetadata(patientMetadata);
		PatientMetadata returnedMetadata = dataservice.getPatientMetadataByPatientId(savedMetadata.getPatientIdentifier(), ScopeFilter.getInstanceForLongitudinalScope());
		
		assertEquals(savedMetadata.getPatientId(), returnedMetadata.getPatientId());
		assertEquals(savedMetadata.getLastAppointmentRequestAccessDate(), returnedMetadata.getLastAppointmentRequestAccessDate());
	}
	
	@Test
	public void testSavePatientMetadata() {
		PatientMetadata patientMetadata = new PatientMetadata();
		Date now = new Date();
		patientMetadata.setPatientIdentifier(new PatientIdentifier("mock-aa", UUID.randomUUID().toString()));
		patientMetadata.setLastAppointmentRequestAccessDate(now);
		
		PatientMetadata savedMetadata = savePatientMetadata(patientMetadata);
		
		assertNotNull(savedMetadata);
		assertEquals(patientMetadata.getPatientId(), savedMetadata.getPatientId());
		assertEquals(patientMetadata.getLastAppointmentRequestAccessDate(), savedMetadata.getLastAppointmentRequestAccessDate());
	}
	
	private PatientMetadata savePatientMetadata(PatientMetadata patientMetadata) {
		PatientMetadata savedMetadata = dataservice.savePatientMetadata(patientMetadata, ScopeFilter.getInstanceForLongitudinalScope());
		
		return savedMetadata;
	}

	@Test
	public void validateFetchAndUpdateLastAccessDate(){
		Date before = dataservice.fetchAndUpdateLastAccessDate(patientIdentifierWithNoData, ScopeFilter.getInstanceForLongitudinalScope());
		assertNotNull(before);
		Date after = dataservice.fetchAndUpdateLastAccessDate(patientIdentifierWithNoData, ScopeFilter.getInstanceForLongitudinalScope());
		assertNotNull(after);
		assertTrue(before.before(after));
	}
	
}
