package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.MockRouterHelper;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientSearchResults;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationMock;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class PatientDataServiceTest {

	@Test
	public void fetchSinglePatient() {
		PatientDataService dataservice = initializeDataServiceForFetch();
		Patient patient = dataservice.getPatient(PatientCorrelationMock.GallowEnterprisePatientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(PatientCorrelationMock.GallowEnterprisePatientIdentifier, patient.getPatientIdentifier());
		assertEquals("Gallow", patient.getLastName());
	}

	private PatientDataService initializeDataServiceForFetch() {
		Patient patient = new Patient();
		patient.setPatientIdentifier(PatientCorrelationMock.GallowEnterprisePatientIdentifier);
		patient.setLastName("Gallow");

		Router router = MockRouterHelper.createMockRouterToReturnPatient(patient);
		return new PatientDataService(router);
	}

	@Test
	public void performPatientSearch() {
		PatientDataService dataservice = initializeDataServiceForSearch();
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		PatientSearchResults patientSearchResults = dataservice.patientSearch(criteria, ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(3, patientSearchResults.getSize());
	}

	private PatientDataService initializeDataServiceForSearch() {
		Patients patients = new Patients();

		Patient patient = new Patient();
		patient.setPatientIdentifier(PatientCorrelationMock.GallowEnterprisePatientIdentifier);
		patient.setLastName("Gallow");
		patients.add(patient);

		patient = new Patient();
		patient.setPatientIdentifier(new PatientIdentifier("aa", "1"));
		patient.setLastName("One");
		patients.add(patient);

		patient = new Patient();
		patient.setPatientIdentifier(new PatientIdentifier("aa", "2"));
		patient.setLastName("Two");
		patients.add(patient);

		Router router = MockRouterHelper.createMockRouterToReturnPatients(patients);
		PatientDataService dataservice = new PatientDataService(router);
		return dataservice;
	}

}
