package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.utility.DateHelper;

public class AgeCalculatorTest {
	@Test
	public void calculateAgeUsingNowReturnsSomething() {
		Date dob = DateHelper.parseDate("1/2/1980");
		assertTrue(AgeCalculator.calculateAge(dob) > 30);
	}

	@Test
	public void calculateAgeWithoutBdayReturns0() {
		Date dob = null;
		assertEquals(0, AgeCalculator.calculateAge(dob));
	}

	@Test
	public void calculateAgeWithExactDeltaInYears() {
		Date dob = DateHelper.parseDate("1/2/1980");
		Date referenceDate = DateHelper.parseDate("1/2/2011");
		assertEquals(31, AgeCalculator.calculateAge(dob, referenceDate));
	}

	@Test
	public void calculateAgeAlmostToBday() {
		Date dob = DateHelper.parseDate("1/2/1980");
		Date referenceDate = DateHelper.parseDate("1/1/2011");
		assertEquals(30, AgeCalculator.calculateAge(dob, referenceDate));
	}

	@Test
	public void calculateAgeRightAfterBday() {
		Date dob = DateHelper.parseDate("1/2/1980");
		Date referenceDate = DateHelper.parseDate("1/3/2011");
		assertEquals(31, AgeCalculator.calculateAge(dob, referenceDate));
	}

	@Test
	public void calculateAgeBDayOnLeapDay() {
		Date dob = DateHelper.parseDate("2/29/2008");
		Date referenceDate = DateHelper.parseDate("3/1/2011");
		assertEquals(3, AgeCalculator.calculateAge(dob, referenceDate));
	}

	@Test
	public void calculateAgeTodayLeapDay() {
		Date dob = DateHelper.parseDate("2/28/2000");
		Date referenceDate = DateHelper.parseDate("2/29/2008");
		assertEquals(8, AgeCalculator.calculateAge(dob, referenceDate));
	}
}
