package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.PainGoalEntryStatus;
import com.agilex.healthcare.utility.PainGoalStatus;
import org.junit.Test;

import java.util.Date;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

public class PainGoalReportGeneratorTest {

    @Test
    public void generatesPainGoalReport() {
        PainGoals painGoals = createPainGoals();

        PainGoalReportGenerator generator = createPainGoalRGoalReportGenerator(painGoals);

        PainGoalReport report = generator.generateReport();

        String reportText = report.getReport();
        assertNotNull(reportText);
        assertTrue(reportText.contains("<center>Pain Goal Report</center>"));
        Date today = DateHelper.getToday();
        String todayFormatted = DateHelper.formatDateTimeInReportFormat(today);
        assertTrue(reportText.contains("<center>Created on " + todayFormatted + "</center>"));

        assertTrue(reportText.contains("<u>Active Goals</u>"));
        assertTrue(reportText.contains("Name: Run Marathon"));
        assertTrue(reportText.contains("50%"));
        assertTrue(reportText.contains("Date Started: 01/01/2012"));
        assertTrue(reportText.contains("Target Date: 12/31/2012"));


        assertTrue(reportText.contains("Completed Action Steps"));
        assertTrue(reportText.contains("<li>02/01/2012: Buy Shoes</li>"));

        assertTrue(reportText.contains("<u>Completed Goals</u>"));
        assertTrue(reportText.contains("Name: Run 10k"));
        assertTrue(reportText.contains("Date Started: 08/01/2011"));
        assertTrue(reportText.contains("Completed Date: 09/01/2011"));
        assertTrue(reportText.contains("Details: Details here"));

        assertTrue(reportText.contains("<u>Deleted Goals</u>"));
        assertTrue(reportText.contains("Name: Run Ultra"));
        assertTrue(reportText.contains("Date Started: 09/01/2011"));
        assertTrue(reportText.contains("Date Deleted: 11/01/2011"));

    }


    private PainGoalReportGenerator createPainGoalRGoalReportGenerator(PainGoals painGoals){
        return new PainGoalReportGenerator(painGoals);
    }

    private PainGoals createPainGoals() {
        PainGoals painGoals = new PainGoals();
        PainGoal painGoal = new PainGoal();
        painGoal.setStatus(PainGoalStatus.PainGoalStatusActive);
        painGoal.setName("Run Marathon");
        painGoal.setPercentComplete("50");
        painGoal.setTargetDate(DateHelper.parseDate("12/31/2012"));
        painGoal.setDateStarted(DateHelper.parseDate("01/01/2012"));
        PainGoalEntries painGoalEntries = new PainGoalEntries();
        PainGoalEntry entry = new PainGoalEntry();
        entry.setComments("Buy Shoes");
        entry.setStatus(PainGoalEntryStatus.PainGoalEntryStatusComplete);
        entry.setEntryDate(DateHelper.parseDate("02/01/2012"));
        painGoalEntries.add(entry);
        painGoal.setPainGoalEntries(painGoalEntries);
        painGoals.add(painGoal);

        painGoal = new PainGoal();
        painGoal.setStatus(PainGoalStatus.PainGoalStatusComplete);
        painGoal.setName("Run 10k");
        painGoal.setDateStarted(DateHelper.parseDate("08/01/2011"));
        painGoal.setDateCompleted(DateHelper.parseDate("09/01/2011"));
        painGoal.setDetails("Details here");
        painGoals.add(painGoal);

        painGoal = new PainGoal();
        painGoal.setStatus(PainGoalStatus.PainGoalStatusDeleted);
        painGoal.setName("Run Ultra");
        painGoal.setDateStarted(DateHelper.parseDate("09/01/2011"));
        painGoal.setDateDeleted(DateHelper.parseDate("11/01/2011"));
        painGoals.add(painGoal);

        painGoal.setPainGoalEntries(new PainGoalEntries());
        return painGoals;
    }



}
