package com.agilex.healthcare.mobilehealthplatform.datalayer.notification;

import static org.junit.Assert.assertEquals;
import static org.mockito.Matchers.anyObject;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import java.util.Date;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.MockRouterHelper;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.DeviceRegistration;
import com.agilex.healthcare.mobilehealthplatform.domain.DeviceRegistrations;
import com.agilex.healthcare.mobilehealthplatform.domain.NotificationUser;
import com.agilex.healthcare.mobilehealthplatform.domain.NotificationUsers;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationMock;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationService;

public class NotificationUserDataServiceTest {
	private PatientDataService patientDataService;
	private DeviceRegistrationDataService deviceRegistrationDataService;

	@Before
	public void setup() {
		setupPatientDataService();
		setupDeviceRegistrationDataService();
	}

	private void setupPatientDataService() {
		Patients patients = new Patients();
		patients.add(createPatient("userId1", "samelastname", "firstname1", "111111111"));
		patients.add(createPatient("userId2", "samelastname", "firstname2", "222222222"));
		patients.add(createPatient("userId3", "samelastname", "firstname3", "333333333"));

		Router mockRouter = MockRouterHelper.createMockRouterToReturnPatients(patients);
		patientDataService = new PatientDataService(mockRouter);
	}

	private Patient createPatient(String id, String lastname, String firstname, String SSN) {
		Patient patient = new Patient();
		patient.setPatientIdentifier(new PatientIdentifier("EDIPI", id));
		patient.setLastName(lastname);
		patient.setFirstName(firstname);
		patient.setSsn(SSN);
		return patient;
	}

	private void setupDeviceRegistrationDataService() {
		DeviceRegistrations registrations = new DeviceRegistrations();
		registrations.add(createRegistration("deviceIdA", "tokenA", "userId1"));
		registrations.add(createRegistration("deviceIdB", "tokenB", "userId1"));
		registrations.add(createRegistration("deviceIdC", "tokenC", "userId2"));
		registrations.add(createRegistration("deviceIdD", "tokenD", "userId3"));

		deviceRegistrationDataService = new DeviceRegistrationDataService(mock(DeviceRegistrationDataLayer.class), mock(NotificationCommunicationDataLayer.class));

		@SuppressWarnings("unchecked")
		List<String> anyStringList = (List<String>) anyObject();
		when(deviceRegistrationDataService.fetchRegistrations(anyStringList)).thenReturn(registrations);
	}

	private DeviceRegistration createRegistration(String deviceId, String token, String userId) {
		DeviceRegistration deviceRegistration = new DeviceRegistration(userId, token, userId + "first", userId + "last");
		deviceRegistration.setDeviceRegistrationId(deviceId);
		deviceRegistration.setRegisteredDate(new Date());
		return deviceRegistration;
	}

	@Test
	public void searchNotificationUserByLastName() {
		PatientCorrelationService patientCorrelationService = new PatientCorrelationMock(){
			@Override
			public PatientIdentifiers getCorrespondIdentifiers(PatientIdentifier patientIdentifier, String targetAssigningAuthority) {
				PatientIdentifiers patientIdentifiers = new PatientIdentifiers();
				patientIdentifiers.add(patientIdentifier);
				return patientIdentifiers;
			}
		};
		NotificationUserDataService notificationUserDataService = new NotificationUserDataService(patientDataService, deviceRegistrationDataService, patientCorrelationService);
		NotificationUsers notificationUsers = notificationUserDataService.searchNotificationUsers("testSearchSameLastName", "688");

		assertEquals(3, notificationUsers.size());
		for (NotificationUser notificationUser : notificationUsers) {
			assertEquals("samelastname", notificationUser.getLastName());
		}
	}
}