package com.agilex.healthcare.mobilehealthplatform.datalayer.medication.rxrefill;

import java.util.*;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.MedicationRefillCode;
import com.agilex.healthcare.utility.DateHelper;

public class MedicationRefillDataServiceTest {

	String patientId;
	String medicationId; 

	MedicationRefillDataService dataService = new MedicationRefillDataService(new Router());
	
	@Before
	public void before() {
		patientId = UUID.randomUUID().toString();
		medicationId = UUID.randomUUID().toString();
	}
	
	@Test
	public void validateFirstRequest() {
		Medication medication = createMedication(DateHelper.getTomorrow());
		Medications medications = new Medications(medication);
		
		Medications refillable = dataService.reviewWithRequestRecords(medications, new MedicationRefillRequests());
		
		Assert.assertEquals(1, refillable.size());
		Assert.assertEquals(MedicationRefillCode.REFILL_ACTION_ELIGIBLE, refillable.get(0).getRefillAction());
	}
	
	@Test
	public void validateWithPreviousRequest() {
		Medication medication = createMedication(DateHelper.xDaysBeforeNow(20));
		Medications medications = new Medications(medication);
		
		MedicationRefillRequest refillRequest = createRequest(DateHelper.getToday());
		MedicationRefillRequests refillRequests = new MedicationRefillRequests(refillRequest);
		
		Medications refillable = dataService.reviewWithRequestRecords(medications, refillRequests);
		
		Assert.assertEquals(1, refillable.size());
		Assert.assertEquals(MedicationRefillCode.REFILL_ACTION_NONE, refillable.get(0).getRefillAction());
	}
	
	@Test
	public void validateAlreadyInvalid() {
		Medication medication = createMedication(DateHelper.xDaysBeforeNow(50));
		medication.setRefillAction(MedicationRefillCode.REFILL_ACTION_NONE);
		Medications medications = new Medications(medication);
		
		MedicationRefillRequest refillRequest = createRequest(DateHelper.getToday());
		MedicationRefillRequests refillRequests = new MedicationRefillRequests(refillRequest);
		
		Medications refillable = dataService.reviewWithRequestRecords(medications, refillRequests);
		Assert.assertEquals(1, refillable.size());
		Assert.assertEquals(MedicationRefillCode.REFILL_ACTION_NONE, refillable.get(0).getRefillAction());
	}
	
	@Test
	public void validateMultiple() {
		Medication medication = createMedication(DateHelper.xDaysBeforeNow(50));
		medication.setRefillAction(MedicationRefillCode.REFILL_ACTION_NONE);
		medication.setUniqueId(UUID.randomUUID().toString());
		Medication medication2 = createMedication(DateHelper.xDaysBeforeNow(12));
		medication.setRefillAction(MedicationRefillCode.REFILL_ACTION_ELIGIBLE);
		Medications medications = new Medications(medication, medication2);
		
		MedicationRefillRequest refillRequest = createRequest(DateHelper.getToday());
		MedicationRefillRequests refillRequests = new MedicationRefillRequests(refillRequest);
		
		Medications refillable = dataService.reviewWithRequestRecords(medications, refillRequests);
		Assert.assertEquals(2, refillable.size());
	}
	
	Medication createMedication(Date calculatedNextDate) {
		Medication medication = new Medication();
		medication.setUniqueId(medicationId);
		medication.setCalculatedNextFillDate(calculatedNextDate);
		medication.setRefillAction(MedicationRefillCode.REFILL_ACTION_ELIGIBLE);
		
		return medication;
	}
	
	MedicationRefillRequest createRequest(Date requestDate) {
		return new MedicationRefillRequest(patientId, medicationId, requestDate);
	}
}
