package com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro;

import java.util.Date;

import junit.framework.Assert;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class MicrobiologyLabGrouperTest {

	LabTests labTests;
	
	public MicrobiologyLabGrouperTest() {
		labTests = new LabTests();
		
		LabResult labResult = new LabResult();
		labResult.setResultedDate(new Date());
		
		LabTest labTest = new LabTest();
		labTest.setTestname("Test 1");
		labTest.setSpecimenName("Blood");
		labTest.setLabResults(new LabResults(labResult));
		labTests.add(labTest);
		
		labTest = new LabTest();
		labTest.setTestname("Test 1");
		labTest.setSpecimenName("Blood");
		labTest.setLabResults(new LabResults(labResult));
		labTests.add(labTest);
		
		labTest = new LabTest();
		labTest.setTestname("Test 2");
		labTest.setSpecimenName("Serum");
		labTest.setLabResults(new LabResults(labResult));
		labTests.add(labTest);
		
		labTest = new LabTest();
		labTest.setTestname("Test 2");
		labTest.setSpecimenName("Blood");
		labTest.setLabResults(new LabResults(labResult));
		labTests.add(labTest);
	}
	
	@Test
	public void verifyGrouping() {
		MicrobiologyLabGrouper grouper = new MicrobiologyLabGrouper();
		LabTestGroups testGroups = grouper.groupAndSort(labTests);
		
		Assert.assertEquals(3, testGroups.size());
	}
	
}
