package com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.MockRouterHelper;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.DateHelper;

public class MicrobiologyLabDataServiceRetrieveAllResultsTest {
	PatientIdentifier patientIdentifier = new PatientIdentifier("a", "1");
	PatientIdentifier patientIdentifierZeroResults = new PatientIdentifier("a", "2");
	PatientIdentifier patientIdentifierNullResults = new PatientIdentifier("a", "3");

	@Test
	public void retrieveLabs() {
		MicrobiologyLabDataService labdataservice = initializeMockWithData();
		LabResults retrievedResults = labdataservice.getLabResultsWithTextResults(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(2, retrievedResults.size());
	}

	@Test
	public void retrieveLabsZeroResults() {
		MicrobiologyLabDataService labdataservice = initializeMockWithNoData();
		LabResults retrievedResults = labdataservice.getLabResultsWithTextResults(patientIdentifierZeroResults, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(0, retrievedResults.size());
	}

	@Test
	public void retrieveLabsNullResults() {
		MicrobiologyLabDataService labdataservice = initializeMockWithNullData();
		LabResults retrievedResults = labdataservice.getLabResultsWithTextResults(patientIdentifierNullResults, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(0, retrievedResults.size());
	}

	private MicrobiologyLabDataService initializeMockWithData() {
		LabResults labresults = new LabResults();
		LabResult labresult;

		labresult = new LabResult();
		labresult.setPatientIdentifier(patientIdentifier);
		labresult.setTestId("TestA");
		labresult.setResultedDate(DateHelper.parseDate("1/1/2010"));
		labresults.add(labresult);

		labresult = new LabResult();
		labresult.setPatientIdentifier(patientIdentifier);
		labresult.setTestId("TestB");
		labresult.setResultedDate(DateHelper.parseDate("1/1/2009"));
		labresults.add(labresult);

		Router router = MockRouterHelper.createMockRouterToReturnPatientDataList(labresults);
		return new MicrobiologyLabDataService(router);
	}

	private MicrobiologyLabDataService initializeMockWithNoData() {
		return new MicrobiologyLabDataService(MockRouterHelper.createMockRouterToReturnPatientDataList(new LabResults()));
	}

	private MicrobiologyLabDataService initializeMockWithNullData() {
		LabResults labresults = null;
		return new MicrobiologyLabDataService(MockRouterHelper.createMockRouterToReturnPatientDataList(labresults));
	}
}
