package com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.LabResultOrganizer;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.utility.DateHelper;

public class LabResultOrganizerTest {

	@Test
	public void groupTests() {
		LabResults labResults = new LabResults();

		LabResult labResultA = new LabResult();
		labResultA.setTestId("A");
		labResultA.setTestname("A");
		labResults.add(labResultA);

		LabResult labResultB = new LabResult();
		labResultB.setTestId("B");
		labResults.add(labResultB);

		LabResultOrganizer organizer = new LabResultOrganizer();
		LabTests tests = organizer.groupByTest(labResults);

		assertNotNull(tests);
		assertEquals(2, tests.size());
		assertEquals("A", tests.get(0).getUniqueId());
	}

	@Test
	public void sortTests() {
		LabResults labResults = new LabResults();

		LabResult labResultA = new LabResult();
		labResultA.setTestId("A");
		labResultA.setTestname("A");
		labResults.add(labResultA);

		LabResult labResultC = new LabResult();
		labResultC.setTestId("C");
		labResults.add(labResultC);

		LabResult labResultB = new LabResult();
		labResultB.setTestId("B");
		labResults.add(labResultB);

		LabResultOrganizer organizer = new LabResultOrganizer();
		LabTests tests = organizer.groupByTest(labResults);

		assertNotNull(tests);
		assertEquals(3, tests.size());
		assertEquals("A", tests.get(0).getUniqueId());
		assertEquals("B", tests.get(1).getUniqueId());
		assertEquals("C", tests.get(2).getUniqueId());
	}

	@Ignore
	public void sortResults() {
		LabResults labResults = new LabResults();

		LabResult labResultA = new LabResult();
		labResultA.setTestId("A");
		labResultA.setTestname("A");
		labResults.add(labResultA);

		LabResult labResultC1 = new LabResult();
		labResultC1.setTestId("C");
		labResultC1.setResultedDate(DateHelper.parseDate("1/1/2011"));
		labResults.add(labResultC1);

		LabResult labResultC2 = new LabResult();
		labResultC2.setTestId("C");
		labResultC2.setResultedDate(DateHelper.parseDate("1/3/2011"));
		labResults.add(labResultC2);

		LabResult labResultC3 = new LabResult();
		labResultC3.setTestId("C");
		labResultC3.setResultedDate(DateHelper.parseDate("1/2/2011"));
		labResults.add(labResultC3);

		LabResult labResultB = new LabResult();
		labResultB.setTestId("B");
		labResults.add(labResultB);

		LabResultOrganizer organizer = new LabResultOrganizer();
		LabTests tests = organizer.groupByTest(labResults);

		assertNotNull(tests);
		assertEquals(3, tests.size());
		assertEquals("C", tests.get(2).getUniqueId());
		assertEquals(labResultC2, tests.get(2).getLabResults().get(0));
		assertEquals(labResultC1, tests.get(2).getLabResults().get(1));
		assertEquals(labResultC3, tests.get(2).getLabResults().get(2));
	}

}
