package com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.LabResultOrganizer;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.utility.DateHelper;

public class LabResultOrganizer2Test {

	@Test
	public void groupTests() {
		LabResults labResults = new LabResults();

		LabResult labResultA = new LabResult();
		labResultA.setTestId("A");
		labResultA.setTestname("A");
		labResults.add(labResultA);

		LabResult labResultB = new LabResult();
		labResultB.setTestId("B");
		labResults.add(labResultB);

		LabResultOrganizer organizer = new LabResultOrganizer();
		LabTests tests = organizer.groupByTest(labResults);

		assertNotNull(tests);
		assertEquals(2, tests.size());
		assertEquals("A", tests.get(0).getUniqueId());
	}

	@Test
	public void sortTests() {
		LabResults labResults = new LabResults();

		LabResult labResultB = new LabResult();
		labResultB.setTestId("B");
		labResultB.setTestname("B");
		labResults.add(labResultB);

		LabResult labResultA = new LabResult();
		labResultA.setTestId("A");
		labResultA.setTestname("A");
		labResults.add(labResultA);

		LabResult labResultC = new LabResult();
		labResultC.setTestId("C");
		labResultC.setTestname("C");
		labResults.add(labResultC);

		LabResultOrganizer organizer = new LabResultOrganizer();
		LabTests tests = organizer.groupByTest(labResults);

		assertNotNull(tests);
		assertEquals(3, tests.size());
		assertEquals("A", tests.get(0).getUniqueId());
		assertEquals("B", tests.get(1).getUniqueId());
		assertEquals("C", tests.get(2).getUniqueId());
	}

	@Test
	public void sortResults() {
		LabResults labResults = new LabResults();

		LabResult labResultB1 = new LabResult();
		labResultB1.setTestId("B");
		labResultB1.setTestname("B");
		labResultB1.setResultedDate(DateHelper.parseDate("1/1/2010"));
		labResults.add(labResultB1);

		LabResult labResultB3 = new LabResult();
		labResultB3.setTestId("B");
		labResultB3.setTestname("B");
		labResultB3.setResultedDate(DateHelper.parseDate("1/3/2010"));
		labResults.add(labResultB3);

		LabResult labResultB2 = new LabResult();
		labResultB2.setTestId("B");
		labResultB2.setTestname("B");
		labResultB2.setResultedDate(DateHelper.parseDate("1/2/2010"));
		labResults.add(labResultB2);

		LabResult labResultA = new LabResult();
		labResultA.setTestId("A");
		labResultA.setTestname("A");
		labResults.add(labResultA);

		LabResult labResultC = new LabResult();
		labResultC.setTestId("C");
		labResultC.setTestname("C");
		labResults.add(labResultC);

		LabResultOrganizer organizer = new LabResultOrganizer();
		LabTests tests = organizer.groupByTest(labResults);

		assertNotNull(tests);
		assertEquals(3, tests.size());
		assertEquals("B", tests.get(1).getUniqueId());

		assertEquals(labResultB3, tests.get(1).getLabResults().get(0));
		assertEquals(labResultB2, tests.get(1).getLabResults().get(1));
		assertEquals(labResultB1, tests.get(1).getLabResults().get(2));
	}

	@Ignore
	public void groupByTestAndSpecimen() {
		LabResults labResults = new LabResults();

		LabResult labResultA = new LabResult();
		labResultA.setTestId("A");
		labResultA.setSpecimenId("SA");
		labResults.add(labResultA);

		LabResult labResultB = new LabResult();
		labResultB.setTestId("A");
		labResultB.setSpecimenId("SA");
		labResults.add(labResultB);

		LabResult labResultC = new LabResult();
		labResultC.setTestId("A");
		labResultC.setSpecimenId("SB");
		labResults.add(labResultC);

		LabResult labResultD = new LabResult();
		labResultD.setTestId("B");
		labResultD.setSpecimenId("SA");
		labResults.add(labResultD);

		LabResultOrganizer organizer = new LabResultOrganizer();

		LabTests tests = organizer.groupByTest(labResults);

		assertEquals(3, tests.size());

		assertEquals("A", tests.get(0).getUniqueId());
		assertEquals("SA", tests.get(0).getSpecimenId());
		assertEquals(2, tests.get(0).getLabResults().size());

		assertEquals("A", tests.get(1).getUniqueId());
		assertEquals("SB", tests.get(1).getSpecimenId());
		assertEquals(1, tests.get(1).getLabResults().size());

		assertEquals("B", tests.get(2).getUniqueId());
		assertEquals("SA", tests.get(2).getSpecimenId());
		assertEquals(1, tests.get(2).getLabResults().size());
	}
}
