package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import org.junit.Assert;
import org.junit.Test;


public class ChemistryLabGraphableTest {

    ChemistryLabDataService dataService = new ChemistryLabDataService();

    @Test
    public void validateGraphableForInteger() {
        LabResults labResults = generateLabResults("1");
        dataService.labResultsGraphable(labResults);
        LabResult result = labResults.get(0);

        Assert.assertTrue(result.isGraphable());
    }

    @Test
    public void validateGraphableForDouble() {
        LabResults labResults = generateLabResults("3.14159");
        dataService.labResultsGraphable(labResults);
        LabResult result = labResults.get(0);

        Assert.assertTrue(result.isGraphable());
    }

    @Test
    public void validateNotGraphableForNull() {
       LabResults labResults = generateLabResults(null);
        dataService.labResultsGraphable(labResults);
        LabResult result = labResults.get(0);

        Assert.assertFalse(result.isGraphable());
    }

    @Test
    public void validateNotGraphableForString() {
        LabResults labResults = generateLabResults("notNumeric");
        dataService.labResultsGraphable(labResults);
        LabResult result = labResults.get(0);

        Assert.assertFalse(result.isGraphable());
    }

    @Test
    public void validateNotGraphableForSymbols() {
        LabResults labResults = generateLabResults("1+");
        dataService.labResultsGraphable(labResults);
        LabResult result = labResults.get(0);

        Assert.assertFalse(result.isGraphable());
    }

    public LabResults generateLabResults(String value) {
        LabResult labResult = new LabResult();
        labResult.setValue(value);

        return new LabResults(labResult);
    }
}
