package com.agilex.healthcare.mobilehealthplatform.datalayer.documents;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentService;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Document;
import com.agilex.healthcare.mobilehealthplatform.domain.DocumentBody;
import com.agilex.healthcare.mobilehealthplatform.domain.Documents;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

@Ignore
public class DocumentServiceTest {

	private static final PatientIdentifier patientIdentifierWithDocuments = new PatientIdentifier("EDIPI", "D123401");
	private static final PatientIdentifier patientIdentifierForNewDocument = new PatientIdentifier("", "ABC");
	private static final PatientIdentifier patientIdentifierWithNoDocuments = new PatientIdentifier("", "invalid");
	private static final DataIdentifier documentIdentifier = new DataIdentifier("", "pi1");

	private DocumentFilter EmptyDocumentFilter = new DocumentFilter();

	private ScopeFilter scope = ScopeFilter.getInstanceForLongitudinalScope();

	private DocumentService getDocumentDataService() {
		return new DocumentService();
	}

	// private ServiceRegistry getMockServiceRegistry() {
	// ServiceRegistry serviceRegistry = mock(ServiceRegistry.class);
	// Community community = mock(Community.class);
	// DataLayerFactory datalayerfactory = mock(DataLayerFactory.class);
	// when(datalayerfactory.getDocumentDataLayer()).thenReturn(new
	// DocumentDataLayerPed());
	// when(community.getDataLayerFactory()).thenReturn(datalayerfactory);
	// when(serviceRegistry.getPrimaryCommunity()).thenReturn(community);
	// return serviceRegistry;
	// }

	@Test
	public void fetchPatientDocuments() {
		DocumentService service = getDocumentDataService();
		Documents documents = service.fetchDocumentsForPatient(patientIdentifierWithDocuments, EmptyDocumentFilter, scope);
		assertEquals(14, documents.getSize());
	}

	@Test
	public void fetchPatientDocuments0Returned() {
		DocumentService service = getDocumentDataService();
		Documents documents = service.fetchDocumentsForPatient(patientIdentifierWithNoDocuments, EmptyDocumentFilter, scope);
		assertEquals(0, documents.getSize());
	}

	@Test
	public void fetchSingleDocument() {
		DocumentService service = getDocumentDataService();
		Document retrievedDocument = service.fetchSingleDocument(patientIdentifierWithDocuments, documentIdentifier);
		assertNotNull(retrievedDocument);
		assertEquals(documentIdentifier.getUniqueId(), retrievedDocument.getUniqueId());
	}

	@Test
	public void fetchSingleDocumentContainsBody() {
		DocumentService service = getDocumentDataService();
		Document document = service.fetchSingleDocument(patientIdentifierWithDocuments, documentIdentifier);
		assertNotNull(document.getBody());
	}

	@Test
	public void createNewDocument() {
		DocumentService service = getDocumentDataService();
		Documents retrievedDocuments = service.fetchDocumentsForPatient(patientIdentifierForNewDocument, scope);
		int initialRetrievedDocumentCount = retrievedDocuments.size();

		Document document = new Document();
		document.setPatientIdentifier(patientIdentifierForNewDocument);
		DocumentBody body = new DocumentBody();
		document.setBody(body);

		ScopeFilter scopeFilter = ScopeFilter.getInstanceForLongitudinalScope();
		Document savedDocument = service.createDocument(document, scopeFilter);

		retrievedDocuments = service.fetchDocumentsForPatient(patientIdentifierForNewDocument, scope);
		assertEquals(initialRetrievedDocumentCount + 1, retrievedDocuments.size());

		Document retrievedDocument = service.fetchSingleDocument(patientIdentifierForNewDocument, savedDocument.getDataIdentifier());
		assertNotNull(retrievedDocument);
	}

	@Test
	public void createNewDocumentAssociatedWithData() {
		DocumentService service = getDocumentDataService();
		DataIdentifier relatedDataIdentifier1 = new DataIdentifier("mock-aa", "id1");
		DataIdentifier relatedDataIdentifier2 = new DataIdentifier("mock-aa", "id2");
		Documents retrievedDocuments1 = service.fetchDocumentsForPatientAssociatedWithPatientData(patientIdentifierForNewDocument, "vitals", relatedDataIdentifier1, scope);
		assertEquals(0, retrievedDocuments1.size());
		Documents retrievedDocuments2 = service.fetchDocumentsForPatientAssociatedWithPatientData(patientIdentifierForNewDocument, "vitals", relatedDataIdentifier2, scope);
		assertEquals(0, retrievedDocuments2.size());

		Document document = createTestDocument(patientIdentifierForNewDocument, "hello world!");
		service.createDocumentAssociatedWithPatientData(document, "vitals", relatedDataIdentifier1, scope);

		Document document2 = createTestDocument(patientIdentifierForNewDocument, "goodbye world!");
		service.createDocumentAssociatedWithPatientData(document2, "vitals", relatedDataIdentifier2, scope);

		validateRetrieve(service, patientIdentifierForNewDocument, "vitals", relatedDataIdentifier1, "hello world!\n");
		validateRetrieve(service, patientIdentifierForNewDocument, "vitals", relatedDataIdentifier2, "goodbye world!\n");
	}

	private Document validateRetrieve(DocumentService service, PatientIdentifier patientIdentifier, String doman, DataIdentifier identifier, String expectedDocumentBody) {
		Documents retrievedDocuments;
		retrievedDocuments = service.fetchDocumentsForPatientAssociatedWithPatientData(patientIdentifier, doman, identifier, scope);
		assertEquals(1, retrievedDocuments.size());
		Document retrievedDocument = retrievedDocuments.get(0);
		// assertEquals(expectedDocumentBody,
		// StreamHelper.streamToString(retrievedDocument.getBody().getContents()));
		return retrievedDocument;
	}

	private Document createTestDocument(PatientIdentifier patientIdentifier, String string) {
		Document document = new Document();
		document.setPatientIdentifier(patientIdentifier);
		DocumentBody body = new DocumentBody();
		// body.setContents(StreamHelper.stringToStream(string));
		document.setBody(body);
		return document;
	}

}
