package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategory;

public class ZaritToolCalculatorTest {
	private ZaritToolCalculator zaritToolCalculator = new ZaritToolCalculator();

	private final String PLAN_NAME = ZaritToolCalculator.PLAN.getName();
	private final String PLEASANT_NAME = ZaritToolCalculator.PLEASANT.getName();
	private final String RELAX_NAME = ZaritToolCalculator.RELAX.getName();
	private final String SOOTHE_NAME = ZaritToolCalculator.SOOTHE.getName();
	private final String SUPPORT_NAME = ZaritToolCalculator.SUPPORT.getName();
	private final String DISTRACT_NAME = ZaritToolCalculator.DISTRACT.getName();
	private final String CHANGE_NAME = ZaritToolCalculator.CHANGE.getName();
	private final String TIME_OUT_NAME = ZaritToolCalculator.TIME_OUT.getName();

	@Test
	public void emptyArray() {
		int[] highScoringQuestions = {};
		String toolsString = generateToolsString(zaritToolCalculator.getRecommendedToolCategories(highScoringQuestions));

		assertEquals("", toolsString);
	}

	@Test
	public void questionOne() {
		int[] highScoringQuestions = { 1 };
		String toolsString = generateToolsString(zaritToolCalculator.getRecommendedToolCategories(highScoringQuestions));

		String expectedString = PLAN_NAME + "," + PLEASANT_NAME + "," + RELAX_NAME + "," + SOOTHE_NAME + "," + SUPPORT_NAME;
		assertEquals(expectedString, toolsString);
	}

	@Test
	public void questionTwo() {
		int[] highScoringQuestions = { 2 };
		String toolsString = generateToolsString(zaritToolCalculator.getRecommendedToolCategories(highScoringQuestions));

		String expectedString = RELAX_NAME + "," + SUPPORT_NAME;
		assertEquals(expectedString, toolsString);
	}

	@Test
	public void allQuestions() {
		int[] highScoringQuestions = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 };
		String toolsString = generateToolsString(zaritToolCalculator.getRecommendedToolCategories(highScoringQuestions));

		String expectedString = SUPPORT_NAME + "," + RELAX_NAME + "," + CHANGE_NAME + "," + PLEASANT_NAME + "," + SOOTHE_NAME + ","
				+ TIME_OUT_NAME + "," + PLAN_NAME + "," + DISTRACT_NAME;
		assertEquals(expectedString, toolsString);

	}

	private String generateToolsString(ToolCategories toolsWithoutDuplicates) {
		String toolsList = "";
		for (ToolCategory tool : toolsWithoutDuplicates) {
			toolsList += tool.getName() + ",";
		}
		if (toolsList.endsWith(",")) {
			toolsList = toolsList.substring(0, toolsList.length() - 1);
		}
		return toolsList;
	}

}
