package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import static org.junit.Assert.*;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategory;

import edu.emory.mathcs.backport.java.util.Collections;

public class ToolCategoryTest {

	@Test
	public void compareToMoreItemWithHigherRecommendationCount() {
		ToolCategory item = new ToolCategory("a");
		item.increaseRecommendationCount();

		ToolCategory compareToItem = new ToolCategory("b");
		compareToItem.increaseRecommendationCount();
		compareToItem.increaseRecommendationCount();

		assertTrue(0 < item.compareTo(compareToItem));
	}

	@Test
	public void compareToMoreItemWithLowerRecommendationCount() {
		ToolCategory item = new ToolCategory("a");
		item.increaseRecommendationCount();
		item.increaseRecommendationCount();

		ToolCategory compareToItem = new ToolCategory("b");
		compareToItem.increaseRecommendationCount();

		assertTrue(0 > item.compareTo(compareToItem));
	}

	@Test
	public void compareToItemWithSameAndFirstAlpha() {
		ToolCategory item = new ToolCategory("a");
		item.increaseRecommendationCount();

		ToolCategory compareToItem = new ToolCategory("b");
		compareToItem.increaseRecommendationCount();

		assertTrue(0 > item.compareTo(compareToItem));
	}

	@Test
	public void compareToItemWithSameAndLastAlpha() {
		ToolCategory item = new ToolCategory("b");
		item.increaseRecommendationCount();

		ToolCategory compareToItem = new ToolCategory("a");
		compareToItem.increaseRecommendationCount();

		assertTrue(0 < item.compareTo(compareToItem));
	}

	@Test
	public void compareToSame() {
		ToolCategory item = new ToolCategory("a");
		item.increaseRecommendationCount();

		ToolCategory compareToItem = new ToolCategory("a");
		compareToItem.increaseRecommendationCount();

		assertTrue(0 == item.compareTo(compareToItem));
	}

	@Test
	public void sortToolsWithItemAFirst() {
		ToolCategories tools = new ToolCategories();

		ToolCategory a = new ToolCategory("a");
		a.increaseRecommendationCount();
		a.increaseRecommendationCount();
		tools.add(a);

		ToolCategory b = new ToolCategory("b");
		b.increaseRecommendationCount();
		tools.add(b);

		Collections.sort(tools);

		assertEquals("a", tools.get(0).getName());
		assertEquals("b", tools.get(1).getName());
	}

	@Test
	public void sortToolsWithItemASecond() {
		ToolCategories tools = new ToolCategories();

		ToolCategory a = new ToolCategory("a");
		a.increaseRecommendationCount();
		tools.add(a);

		ToolCategory b = new ToolCategory("b");
		b.increaseRecommendationCount();
		b.increaseRecommendationCount();
		tools.add(b);

		Collections.sort(tools);

		assertEquals("a", tools.get(1).getName());
		assertEquals("b", tools.get(0).getName());
	}

}
