package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentProperties;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentProperty;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestionChoice;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestionChoices;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResponse;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResponses;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;

public class ResultScorerTest {
	private SummationScorer scorer = new SummationScorer();
	
	@Test
	public void testCalculateScore() {
		AssessmentResult result = generateMockAssessmentResult();
		int totalScore = scorer.calculateScore(result);
		
		assertNotNull(totalScore);
		assertEquals(6, totalScore);
	}
	
	private AssessmentResult generateMockAssessmentResult() {
		AssessmentResult mockResult = new AssessmentResult();
		mockResult.setAssessmentId("mockId");
		mockResult.setScoringAlgorithm(AssessmentCode.SCORING_ALGORITHM_ZARIT);
		mockResult.setResponses(generateMockResponses());
		mockResult.setScore(scorer.calculateScore(mockResult));
		return mockResult;
	}

	private AssessmentResponses generateMockResponses() {
		AssessmentResponses assessmentResponses = new AssessmentResponses();
		assessmentResponses = addResponse(assessmentResponses, 5);
		assessmentResponses = addResponse(assessmentResponses, 1);
		return assessmentResponses;
	}

	private AssessmentResponses addResponse(AssessmentResponses assessmentResponses, int pointValue) {
		AssessmentResponse assessmentResponse = new AssessmentResponse();
		AssessmentQuestionChoices selectedChoices = new AssessmentQuestionChoices();
		AssessmentQuestionChoice selectedChoice = new AssessmentQuestionChoice();
		AssessmentProperties properties = new AssessmentProperties();

		properties.add(new AssessmentProperty(AssessmentCode.RESULT_PROPERTY_POINT_VALUE, "" + pointValue));
		selectedChoice.setProperties(properties);
		selectedChoices.add(selectedChoice);
		assessmentResponse.setSelectedChoices(selectedChoices);
		assessmentResponses.add(assessmentResponse);

		return assessmentResponses;
	}
}
