package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import static org.junit.Assert.*;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategory;

public class PTSDToolCalculatorTest {
	private PTSDToolCalculator toolCalculator = new PTSDToolCalculator();

	private static final String VISUALIZATION_NAME = PTSDToolCalculator.VISUALIZATION.getName();
	private static final String RID_NAME = PTSDToolCalculator.RID.getName();
	private static final String PLEASANT_NAME = PTSDToolCalculator.PLEASANT.getName();
	private static final String PERSPECTIVE_NAME = PTSDToolCalculator.PERSPECTIVE.getName();
	private static final String GROUNDING_NAME = PTSDToolCalculator.GROUNDING.getName();
	private static final String TIME_OUT_NAME = PTSDToolCalculator.TIME_OUT.getName();
	private static final String SUPPORT_NAME = PTSDToolCalculator.SUPPORT.getName();
	private static final String SLEEP_TIPS_NAME = PTSDToolCalculator.SLEEP_TIPS.getName();
	private static final String DISTRACT_NAME = PTSDToolCalculator.DISTRACT.getName();
	private static final String ISOLATION_NAME = PTSDToolCalculator.ISOLATION.getName();

	@Test
	public void emptyArray() {
		int[] highScoringQuestions = {};
		String toolsString = generateToolsString(toolCalculator.getRecommendedToolCategories(highScoringQuestions));

		assertEquals("", toolsString);
	}

	@Test
	public void printsToolsInAlphabeticalOrderForQuestionOne() {
		int[] highScoringQuestions = { 1 };
		String toolsString = generateToolsString(toolCalculator.getRecommendedToolCategories(highScoringQuestions));

		String expectedString = PERSPECTIVE_NAME + "," + GROUNDING_NAME + "," + ISOLATION_NAME + "," + SUPPORT_NAME + "," + VISUALIZATION_NAME;
		assertEquals(expectedString, toolsString);
	}

	@Test
	public void allQuestionsHaveHighScoringAnswers() {
		int[] highScoringQuestions = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 };
		String toolsString = generateToolsString(toolCalculator.getRecommendedToolCategories(highScoringQuestions));

		String expectedString = SUPPORT_NAME + "," + PERSPECTIVE_NAME + "," + VISUALIZATION_NAME + "," + GROUNDING_NAME + "," + ISOLATION_NAME + ","
				+ PLEASANT_NAME + "," + DISTRACT_NAME + "," + TIME_OUT_NAME + "," + RID_NAME + "," + SLEEP_TIPS_NAME;
		assertEquals(expectedString, toolsString);
	}

	private String generateToolsString(ToolCategories toolsWithoutDuplicates) {
		String toolsList = "";
		for (ToolCategory tool : toolsWithoutDuplicates) {
			toolsList += tool.getName() + ",";
		}
		if (toolsList.endsWith(",")) {
			toolsList = toolsList.substring(0, toolsList.length() - 1);
		}
		return toolsList;
	}
}
