package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;
import com.agilex.healthcare.utility.DateHelper;

import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: clarkee
 * Date: 9/24/12
 * Time: 1:46 PM
 * To change this template use File | Settings | File Templates.
 */
public class MonthlyPainReportTestHelper {

    public static AssessmentResult generateResult(String givenDate, Integer... responsePointValues){
        AssessmentResult previousResult = generateMockAssessmentResult(responsePointValues);
        previousResult.setDateTaken(DateHelper.parseDate(givenDate));
        return previousResult;
    }
    public static AssessmentResult generatePreviousResult(Integer... responsePointValues) {
        AssessmentResult previousResult = generateMockAssessmentResult(responsePointValues);
        Date yesterday = DateHelper.getYesterday();
        previousResult.setDateTaken(yesterday);
        return previousResult;
    }

    public static AssessmentResult generateMockAssessmentResult(Integer... responsePointValues) {
        AssessmentResult mockResult = new AssessmentResult();
        mockResult.setAssessmentId("mockId");
        mockResult.setScoringAlgorithm(AssessmentCode.SCORING_ALGORITHM_UNSCORED);
        mockResult.setResponses(generateMockResponses(responsePointValues));
        Date today = DateHelper.getToday();
        mockResult.setDateTaken(today);
        int totalScore = 0;
        for (Integer responsePointValue : responsePointValues) {
            if (null != responsePointValue){
                totalScore += responsePointValue.intValue();
            }
        }
        mockResult.setScore(totalScore);
        return mockResult;
    }

    private static AssessmentResponses generateMockResponses(Integer... responsePointValues) {
        //generate in reverse order just so we can make sure the report generates in correct order
        AssessmentResponses assessmentResponses = new AssessmentResponses();

        int questionNumber = responsePointValues.length;
        for (int i = responsePointValues.length - 1; i >= 0; i--) {
            Integer pointValue = responsePointValues[i];
            assessmentResponses = addResponse(assessmentResponses, pointValue, questionNumber);
            questionNumber--;
        }

        return assessmentResponses;
    }

    private static AssessmentResponses addResponse(AssessmentResponses assessmentResponses, Integer pointValue, int questionNumber) {
        AssessmentResponse assessmentResponse = new AssessmentResponse();
        AssessmentQuestionChoices selectedChoices = new AssessmentQuestionChoices();
        AssessmentQuestionChoice selectedChoice = new AssessmentQuestionChoice();
        AssessmentProperties properties = new AssessmentProperties();
        AssessmentQuestion assessmentQuestion = new AssessmentQuestion();

        properties.add(new AssessmentProperty(AssessmentCode.RESULT_PROPERTY_SELECTED_VALUE, "" + pointValue));
        selectedChoice.setProperties(properties);
        selectedChoices.add(selectedChoice);
        assessmentResponse.setSelectedChoices(selectedChoices);

        assessmentQuestion.setQuestionNumber(questionNumber);
        assessmentQuestion.setId("Q" + questionNumber);
        assessmentResponse.setQuestion(assessmentQuestion);

        assessmentResponses.add(assessmentResponse);
        return assessmentResponses;
    }

}
