package com.agilex.healthcare.mobilehealthplatform.businesslayer;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.MockRouterHelper;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.DateHelper;

public class MedicationDataServiceTest {

	private static final String OUTPATIENT_DRUGNAME = "drug3";
	private static final String INPATIENT_DRUG_NAME = "drug2";
	private static final String PATIENT_ID = "D123401";
	private MedicationFilter emptyFilter = new MedicationFilter();

	private MedicationDataService initializeDataService() {
		Medications medications = new Medications();

		Medication medication = new Medication();
		medication.setDrugName("drug1");
		medication.setActive(true);
		medication.setStartDate(new Date());
		medication.setEndDate(new Date());
		medication.setExpiredDate(DateHelper.minusDays(new Date(), 89));
		medications.add(medication);

		medication = new Medication();
		medication.setDrugName(INPATIENT_DRUG_NAME);
		medication.setActive(true);
		medication.setMedicationSource("INPATIENT");
		medication.setSourceSystem("VA");
		medication.setStartDate(new Date());
		medication.setEndDate(new Date());
		medication.setExpiredDate(DateHelper.getTomorrow());
		medications.add(medication);

		medication = new Medication();
		medication.setDrugName(OUTPATIENT_DRUGNAME);
		medication.setActive(true);
		medication.setMedicationSource("OUTPATIENT");
		medication.setSourceSystem("VA");
		medication.setStartDate(new Date());
		medication.setExpiredDate(DateHelper.getToday());
		medications.add(medication);

		Router router = MockRouterHelper.createMockRouterToReturnPatientDataList(medications);
		return new MedicationDataService(router);
	}

	@Test
	public void getActiveMedicationsForPatient() {
		MedicationDataService dataservice = initializeDataService();
		Medications medications = dataservice.getActivePatientMedications(getPatientIdentifier(), emptyFilter, ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(3, medications.getSize());
	}

	private PatientIdentifier getPatientIdentifier() {
		return new PatientIdentifier("default", PATIENT_ID);
	}
}
