package com.agilex.healthcare.mobilehealthplatform;

import static org.mockito.Matchers.anyObject;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientFetchResponseBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchResponseBuilder;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class MockRouterHelper {

	public static <Ts extends PatientDataCollection<T>, T extends PatientData> Router createMockRouterToReturnPatientDataList(Ts patientDataList) {
		ResponseMessage responseMessage = PatientDataResponseBuilder.fromPatientData(patientDataList).build();
		Router mockRouter = mock(Router.class);
		when(mockRouter.execute((RequestMessage) anyObject())).thenReturn(responseMessage);
		return mockRouter;
	}

	public static <T extends PatientData> Router createMockRouterToReturnPatientData(T patientData) {
		ResponseMessage responseMessage = PatientDataResponseBuilder.fromPatientData(patientData).build();
		Router mockRouter = mock(Router.class);
		when(mockRouter.execute((RequestMessage) anyObject())).thenReturn(responseMessage);
		return mockRouter;
	}

	public static Router createMockRouterToReturnPatient(Patient patient) {
		ResponseMessage responseMessage = PatientFetchResponseBuilder.fromPatientData(patient).build();
		Router mockRouter = mock(Router.class);
		when(mockRouter.execute((RequestMessage) anyObject())).thenReturn(responseMessage);
		return mockRouter;
	}

	public static Router createMockRouterToReturnPatients(Patients patients) {
		ResponseMessage responseMessage = PatientSearchResponseBuilder.fromSearchResults(patients).build();
		Router mockRouter = mock(Router.class);
		when(mockRouter.execute((RequestMessage) anyObject())).thenReturn(responseMessage);
		return mockRouter;
	}
}
