package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.patient;

import java.net.URI;
import java.util.*;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriHelper;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.PatientLinkBuilder;
import com.agilex.healthcare.utility.NullChecker;

/**
 * @deprecated Please use {@link PatientLinkBuilder}
 * 
 */
@Deprecated
public class PatientUriBuilder {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PatientUriBuilder.class);

	public void updatePatientSearchResultsLinks(PatientSearchResults patients, URI requestUri, URI baseUri) {
		if (patients != null) {
			URI selfUri = requestUri;
			patients.setSelfUri(selfUri);
			updatePagingUri(patients);

			for (Patient patient : patients) {
				updatePatientLinks(patient, baseUri);
			}
		}
	}

	private void logLink(AtomLink link, String linkContext) {
		boolean loggingEnabled = false;
		if (loggingEnabled)
			if (link == null) {
				logger.debug("link does not exist");
			} else {
				logger.debug("link exists");
			}
	}

	public void updatePatientLinks(Patient patient, URI baseURI) {
		if (patient != null) {
			logLink(patient.getSelfLink(), "begin update patient links [patientid=" + patient.getId() + "]");

			patient.getLink().clear();

			URI selfUri = createPatientSelfUri(patient, baseURI);

			if (selfUri != null) {
				logLink(patient.getSelfLink(), "selflink pre-update");
				patient.setSelfUri(selfUri);
				logLink(patient.getSelfLink(), "selflink post-update");

				URI extendedDataUri = UriHelper.mergeUri(selfUri, "demographics");
				patient.setDemographicsUri(extendedDataUri);

				URI patientDocumentsUri = createPatientDocumentsUri(selfUri);
				patient.setDocumentsUri(patientDocumentsUri);

				URI patientImageUri = createPatientImageUri(selfUri);
				patient.setPatientImageUri(patientImageUri);

				URI patientActiveProblemsUri = createPatientActiveProblemsUri(selfUri);
				patient.setProblemsUri(patientActiveProblemsUri);

				URI patientOutpatientActiveProblemsUri = createPatientOutpatientActiveProblemsUri(selfUri);
				patient.setOutpatientProblemsUri(patientOutpatientActiveProblemsUri);

				URI patientInpatientActiveProblemsUri = createPatientInpatientActiveProblemsUri(selfUri);
				patient.setInpatientProblemsUri(patientInpatientActiveProblemsUri);

				URI patientAllergiesUri = createPatientAllergiesUri(selfUri);
				patient.setAllergiesUri(patientAllergiesUri);

				URI patientSurgeriesUri = createPatientSurgeriesUri(selfUri);
				patient.setSurgeriesUri(patientSurgeriesUri);
				appendRelatedLink(patient, LinkTitles.PatientEnteredVitals, "vitals");

				appendRelatedLink(patient, LinkTitles.PatientMood, "mood");
				appendRelatedLink(patient, LinkTitles.PatientExercise, "exercise");

				appendRelatedLink(patient, LinkTitles.PatientEnteredVitalsGraphData, "vitals", "graphdata");
				appendRelatedLink(patient, LinkTitles.PatientEnteredVitalsTableData, "vitals", "tabledata");


				appendRelatedLink(patient, LinkTitles.PatientPastAppointments, UriBuilder.fromUri(selfUri).path("appointments").path("past").build());
				appendRelatedLink(patient, LinkTitles.PatientAppointments, UriBuilder.fromUri(selfUri).path("appointments").build());

				appendRelatedLink(patient, LinkTitles.PatientCalendarEvents, "calendar", "calendarEvent");
				appendRelatedLink(patient, LinkTitles.PatientCalendarPublicKey, UriBuilder.fromUri(selfUri).path("calendar").path("key").build());

				appendRelatedLink(patient, LinkTitles.PatientDiet, "diet");

				appendRelatedLink(patient, LinkTitles.PatientContactLogs, "contactLogs");
				appendRelatedLink(patient, LinkTitles.PatientAdmissions, "admissions");
				appendRelatedLink(patient, LinkTitles.DailyEvents, "dailyevents");

				appendRelatedLink(patient, LinkTitles.PatientRadiologyTests, "radiology", "tests");
				appendRelatedLink(patient, LinkTitles.PatientRadiologyResults, "radiology", "results");

				URI patientMedsUri = createPatientMedicationsUri(selfUri);
				patient.setMedicationsUri(patientMedsUri);

				URI patientActiveMedsUri = createPatientActiveMedicationsUri(selfUri);
				patient.setActiveMedicationsUri(patientActiveMedsUri);

				URI patientOutpatientMedsUri = createPatientOutpatientMedicationsUri(selfUri);
				patient.setOutpatientMedicationsUri(patientOutpatientMedsUri);

				URI patientInpatientMedsUri = createPatientInpatientMedicationsUri(selfUri);
				patient.setInpatientMedicationsUri(patientInpatientMedsUri);

				URI patientCurrentOutpatientMedsUri = createPatientCurrentOutpatientMedicationsUri(selfUri);
				patient.setCurrentOutpatientMedicationsUri(patientCurrentOutpatientMedsUri);

				URI patientCurrentInpatientMedsUri = createPatientCurrentInpatientMedicationsUri(selfUri);
				patient.setCurrentInpatientMedicationsUri(patientCurrentInpatientMedsUri);

				URI patientLabResultsUri = createPatientLabResultsUri(selfUri);
				patient.setLabResultsUri(patientLabResultsUri);

				URI patientLabTestsUri = createPatientLabTestsUri(selfUri);
				patient.setLabTestHistoryUri(patientLabTestsUri);

				URI patientLabTestsByGroupUri = createPatientLabTestsByGroupUri(selfUri);
				patient.setLabTestHistoryByGroupUri(patientLabTestsByGroupUri);

				URI patientMicroLabResultsUri = createPatientMicroLabResultsUri(selfUri);
				patient.setMicroLabResultsUri(patientMicroLabResultsUri);

				URI patientMicroLabTestsUri = createPatientMicroLabTestsUri(selfUri);
				patient.setMicroLabTestHistoryUri(patientMicroLabTestsUri);

				URI patientMicroLabTestsByGroupUri = createPatientMicroLabTestsByGroupUri(selfUri);
				patient.setMicroLabTestHistoryByGroupUri(patientMicroLabTestsByGroupUri);

				URI notificationsUri = UriBuilder.fromUri(baseURI).path("notification-service").path("users").path("id").path(patient.getId()).path("notifications").build();
				patient.getLink().addRelatedLink(LinkTitles.PatientNotifications, notificationsUri);

				URI deviceRegistrationUri = UriBuilder.fromUri(baseURI).path("notification-service").path("users").path("id").path(patient.getId()).path("device-registrations").build();
				patient.getLink().addRelatedLink(LinkTitles.PatientDevices, deviceRegistrationUri);

				URI patientMedicationRefillUri = createPatientMedicationRefillsUri(selfUri);
				patient.setMedicationRefillsUri(patientMedicationRefillUri);
			}
		}
	}

//	private Map<String, String> getSectionMapValue(String vitalSectionCode) {
//		Map<String, String> params = new HashMap<String, String>();
//		params.put("section", vitalSectionCode);
//		return params;
//	}

	private AtomLink appendRelatedLink(Patient patient, String uriTitle, String... uriPath) {
		UriBuilder uriBuilder = UriBuilder.fromUri(patient.getSelfUri());
		for (String singleUriPath : uriPath) {
			uriBuilder.path(singleUriPath);
		}
		URI uri = uriBuilder.build();
		return appendRelatedLink(patient, uriTitle, uri);
	}

//	private AtomLink appendRelatedLink(Patient patient, String uriTitle, Map<String, String> params, String... uriPath) {
//		UriBuilder uriBuilder = UriBuilder.fromUri(patient.getSelfUri());
//		for (String singleUriPath : uriPath) {
//			uriBuilder.path(singleUriPath);
//		}
//		if (params != null) {
//			for (String paramKey : params.keySet()) {
//				uriBuilder.queryParam(paramKey, params.get(paramKey));
//			}
//		}
//		URI uri = uriBuilder.build();
//		return appendRelatedLink(patient, uriTitle, uri);
//	}

//	private AtomLink appendSection(AtomLink baseAtomLink, String section) {
//		URI uri = UriBuilder.fromUri(baseAtomLink.getHref()).queryParam("section", section).build();
//		baseAtomLink.setHref(uri);
//		return baseAtomLink;
//	}

	private AtomLink appendRelatedLink(Patient patient, String uriTitle, URI uri) {
		return patient.getLink().addRelatedLink(uriTitle, uri);
	}

	private void updatePagingUri(PatientSearchResults patients) {
		if ((patients.getPaging() != null) && (patients.getPaging().getNextPage() != null)) {
			URI nextPageUri = UriHelper.setQueryString(patients.getSelfUri(), "page", patients.getPaging().getNextPage());
			patients.getLink().addRelatedLink("next-page", nextPageUri);
		}
	}

	private URI createPatientInpatientActiveProblemsUri(URI patientUri) {
		URI activeProblemsUri = UriHelper.mergeUri(patientUri, "problems");
		activeProblemsUri = UriHelper.mergeUri(activeProblemsUri, "inpatient");
		activeProblemsUri = UriHelper.mergeUri(activeProblemsUri, "active");
		return activeProblemsUri;
	}

	private URI createPatientOutpatientActiveProblemsUri(URI patientUri) {
		URI activeProblemsUri = UriHelper.mergeUri(patientUri, "problems");
		activeProblemsUri = UriHelper.mergeUri(activeProblemsUri, "outpatient");
		activeProblemsUri = UriHelper.mergeUri(activeProblemsUri, "active");
		return activeProblemsUri;
	}

	private URI createPatientActiveProblemsUri(URI patientUri) {
		URI activeProblemsUri = UriHelper.mergeUri(patientUri, "problems");
		activeProblemsUri = UriHelper.mergeUri(activeProblemsUri, "active");
		return activeProblemsUri;
	}

	private URI createPatientAllergiesUri(URI patientUri) {
		URI patientAllergiesUri = UriHelper.mergeUri(patientUri, "allergies");
		return patientAllergiesUri;
	}

	private URI createPatientSurgeriesUri(URI patientUri) {
		URI patientSurgeriesUri = UriHelper.mergeUri(patientUri, "surgeries");
		return patientSurgeriesUri;
	}

	private URI createPatientMedicationsUri(URI patientUri) {
		return UriHelper.mergeUri(patientUri, "medications");
	}

	private URI createPatientActiveMedicationsUri(URI patientUri) {
		URI activeMedsUri = UriHelper.mergeUri(patientUri, "medications");
		activeMedsUri = UriHelper.mergeUri(activeMedsUri, "active");
		return activeMedsUri;
	}

	private URI createPatientOutpatientMedicationsUri(URI patientUri) {
		URI outpatientMedsUri = UriHelper.mergeUri(patientUri, "medications");
		outpatientMedsUri = UriHelper.mergeUri(outpatientMedsUri, "outpatient");
		return outpatientMedsUri;
	}

	private URI createPatientInpatientMedicationsUri(URI patientUri) {
		URI inpatientMedsUri = UriHelper.mergeUri(patientUri, "medications");
		inpatientMedsUri = UriHelper.mergeUri(inpatientMedsUri, "inpatient");
		return inpatientMedsUri;
	}

	private URI createPatientCurrentOutpatientMedicationsUri(URI patientUri) {
		URI outpatientMedsUri = UriHelper.mergeUri(patientUri, "medications");
		outpatientMedsUri = UriHelper.mergeUri(outpatientMedsUri, "outpatient");
		outpatientMedsUri = UriHelper.mergeUri(outpatientMedsUri, "current");
		return outpatientMedsUri;
	}

	private URI createPatientCurrentInpatientMedicationsUri(URI patientUri) {
		URI inpatientMedsUri = UriHelper.mergeUri(patientUri, "medications");
		inpatientMedsUri = UriHelper.mergeUri(inpatientMedsUri, "inpatient");
		inpatientMedsUri = UriHelper.mergeUri(inpatientMedsUri, "current");
		return inpatientMedsUri;
	}

	private URI createPatientMedicationRefillsUri(URI patientUri) {
		URI uri = UriHelper.mergeUri(patientUri, "medication-refills");
		return uri;
	}

	private URI createPatientDocumentsUri(URI patientUri) {
		return UriHelper.mergeUri(patientUri, "documents");
	}

	private URI createPatientImageUri(URI patientUri) {
		return UriHelper.mergeUri(patientUri, "patient-image");
	}

	public URI createPatientSelfUri(Patient patient, URI baseUri) {
		URI uri = null;
		if (patient == null) {
			uri = null;
		} else {
			uri = createPatientSelfUri(patient.getPatientIdentifier(), baseUri);
		}
		return uri;
	}

	public URI createPatientSelfUri(PatientIdentifier patientIdentifier, URI baseUri) {
		URI uri = null;
		if (patientIdentifier != null) {
			// logger.debug(String.format("creating patient self link [patientId=%s]",
			// patientIdentifier.toString()));
			uri = null;
			if (NullChecker.isNotNullish(patientIdentifier.getUniqueId()) && NullChecker.isNotNullish(patientIdentifier.getAssigningAuthority())) {
				uri = UriBuilder.fromUri(baseUri).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).build();
			}
		}
		return uri;
	}

	@Deprecated
	public void updateDemographicsLinks(PatientIdentifier patientIdentifier, PatientDemographics extendedData, URI baseURI) {
		URI patientUri = createPatientSelfUri(patientIdentifier, baseURI);

		URI selfUri = UriHelper.mergeUri(patientUri, "demographics");
		extendedData.setSelfUri(selfUri);
	}

	private URI createPatientLabResultsUri(URI patientUri) {
		URI uri = UriHelper.mergeUri(patientUri, "lab");
		uri = UriHelper.mergeUri(uri, "results");
		return uri;
	}

	private URI createPatientLabTestsUri(URI patientUri) {
		URI uri = UriHelper.mergeUri(patientUri, "lab");
		uri = UriHelper.mergeUri(uri, "tests");
		return uri;
	}

	private URI createPatientLabTestsByGroupUri(URI patientUri) {
		return UriBuilder.fromUri(patientUri).path("lab").path("groups").build();
	}

	private URI createPatientMicroLabResultsUri(URI patientUri) {
		URI uri = UriHelper.mergeUri(patientUri, "lab-microbiology");
		uri = UriHelper.mergeUri(uri, "results");
		return uri;
	}

	private URI createPatientMicroLabTestsUri(URI patientUri) {
		URI uri = UriHelper.mergeUri(patientUri, "lab-microbiology");
		uri = UriHelper.mergeUri(uri, "tests");
		return uri;
	}

	private URI createPatientMicroLabTestsByGroupUri(URI patientUri) {
		return UriBuilder.fromUri(patientUri).path("lab-microbiology").path("groups").build();
	}

}
