package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import com.agilex.healthcare.mobilehealthplatform.domain.GraphData;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalTableData;

public class VitalsLinkBuilder extends AbstractSimplePatientDataLinkBuilder<VitalEntries, VitalEntry> {

	public VitalsLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	protected String getDomainSpecificPath() {
		return "vitals";
	}

	public void fillLinks(VitalTableData data, URI requestUri) {
		data.setSelfUri(requestUri);
	}

	public void fillLinks(GraphData data, URI requestUri) {
		data.setSelfUri(requestUri);
	}

}
