package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;
import java.util.Arrays;
import java.util.List;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResult;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResults;
import com.agilex.healthcare.mobilehealthplatform.domain.code.ToolTrackingCode;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.PatientUriHelper;

public class ToolTrackingResultLinkBuilder extends PatientDataLinkBuilder<ToolTrackingResults, ToolTrackingResult> {

	public ToolTrackingResultLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(ToolTrackingResult result) {
		return UriBuilder.fromUri(buildToolTrackingResultBaseUri(result.getPatientIdentifier())).path("system").path(result.getSourceSystem()).path("tool").path("id").path(result.getUniqueId()).build();
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(ToolTrackingResult result) {

	}
	
	public void fillToolRelatedLinks(ToolTrackingResults results, PatientIdentifier patientIdentifer) {
		List<String> toolsList = Arrays.asList(ToolTrackingCode.ACTIVITY_PACING, ToolTrackingCode.DEEP_BREATHING, ToolTrackingCode.DISTRACTION, ToolTrackingCode.SNAP,
				ToolTrackingCode.MUSCLE_RELAXATION, ToolTrackingCode.PLAN_PLEASANT_ACTIVITY,  ToolTrackingCode.SLEEP_TIPS, ToolTrackingCode.VISUALIZATION);
		
		for(String tool : toolsList) {
			results.getLink().addRelatedLink(tool, UriBuilder.fromUri(buildToolTrackingResultBaseUri(patientIdentifer)).path("recent").path("tool").path(tool).build());
		}
	}

	@Override
	protected void fillCustomRelatedLinks(ToolTrackingResults results) {
		
	}

	public URI buildToolTrackingResultBaseUri(PatientIdentifier patientIdentifier) {
		URI patientUri = PatientUriHelper.createPatientSelfUri(patientIdentifier, getBaseUri());
		return UriBuilder.fromUri(patientUri).path("toolTracking").build();
	}
}
