package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategory;

public class ToolCategoriesLinkBuilder {
	private URI baseUri;

	public ToolCategoriesLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}

	public ToolCategories fillLinks(ToolCategories toolCategories, URI resourceUri) {
		setSelfURI(toolCategories, resourceUri);
		return toolCategories;
	}

	public void fillLinks(ToolCategory toolCategory, URI resourceUri) {
		setSelfURI(toolCategory, resourceUri);
	}

	private void setSelfURI(ToolCategories toolCategories, URI resourceUri) {
		toolCategories.setSelfUri(resourceUri);
	}

	private void setSelfURI(ToolCategory toolCategory, URI resourceUri) {
		toolCategory.setSelfUri(resourceUri);
	}
}
