package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage.SecureMessageFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageCode;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessages;
import com.agilex.healthcare.utility.NullChecker;

public class SecureMessageLinkBuilder extends PatientDataLinkBuilder<SecureMessages, SecureMessage> {

	public SecureMessageLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(SecureMessage dataItem) {
		String userId = dataItem.getPatientId();
		return UriBuilder.fromUri(getBaseUri()).path("securemessage-service").path(userId).path("messages").path("id").path(dataItem.getUniqueId()).build();
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(SecureMessage secureMessage) {

		URI secureMessageBaseUri = buildSecureMessageBaseUri(secureMessage);

		secureMessage.getLink().addRelatedLink("read", UriBuilder.fromUri(secureMessageBaseUri).path("messages").path("id").path(secureMessage.getUniqueId()).path("addressee-id").path(secureMessage.getAddresseeId()).path("addressee-oplock").path(secureMessage.getAddresseeOplock()).build());
		secureMessage.getLink().addRelatedLink("reply", UriBuilder.fromUri(secureMessageBaseUri).path("messages").path("id").path(secureMessage.getUniqueId()).build());
		if (canDeleteMessage(secureMessage)) {
			secureMessage.getLink().addRelatedLink("delete", UriBuilder.fromUri(secureMessageBaseUri).path("messages").path("id").path(secureMessage.getUniqueId()).build());
		}
		if (canMoveMessage(secureMessage)) {
			secureMessage.getLink().addRelatedLink("move", UriBuilder.fromUri(secureMessageBaseUri).path("messages").path("id").path(secureMessage.getUniqueId()).path("move").build());
		}
		secureMessage.getLink().addRelatedLink("print", UriBuilder.fromUri(secureMessageBaseUri).path("messages").path("id").path(secureMessage.getUniqueId()).build());
	}

	@Override
	protected void fillCustomRelatedLinks(SecureMessages secureMessages) {
		if (NullChecker.isNotNullish(secureMessages)) {
			addAdditionalLinks(secureMessages);
		}
	}

	private URI buildSecureMessageBaseUri(SecureMessage secureMessage) {
		return UriBuilder.fromUri(getBaseUri()).path("securemessage-service").path(secureMessage.getPatientIdentifier().getAssigningAuthority()).path(secureMessage.getPatientId()).build();
	}

	private URI buildSecureMessagesBaseUri(SecureMessages secureMessages) {
		SecureMessage secureMessage = secureMessages.get(0);
		return UriBuilder.fromUri(getBaseUri()).path("securemessage-service").path(secureMessage.getPatientIdentifier().getAssigningAuthority()).path(secureMessage.getPatientId()).path("folders").path("id").path(secureMessage.getFolderId()).path("messages").build();
	}

	private boolean canMoveMessage(SecureMessage secureMessage) {
		if (SecureMessageCode.FOLDER_ID_INBOX.toString().equals(secureMessage.getFolderId()) || SecureMessageCode.FOLDER_ID_DELETED.toString().equals(secureMessage.getFolderId()) || Integer.parseInt(secureMessage.getFolderId()) > 0) {
			return true;
		}
		return false;
	}

	private boolean canDeleteMessage(SecureMessage secureMessage) {
		if (!SecureMessageCode.FOLDER_ID_SENT.toString().equals(secureMessage.getFolderId())) {
			return true;
		}
		return false;
	}

	private void addAdditionalLinks(SecureMessages secureMessages) {
		URI messagesBaseUri = buildSecureMessagesBaseUri(secureMessages);
		if (secureMessages.hasNext())
			addNextLink(secureMessages, messagesBaseUri);

		if (secureMessages.hasPrevious())
			addPreviousLink(secureMessages, messagesBaseUri);
	}

	public void addNextLink(SecureMessages secureMessages, URI messagesBaseUri) {
		secureMessages.getLink().addRelatedLink("next", UriBuilder.fromUri(messagesBaseUri).queryParam(SecureMessageFilter.PAGE_NUMBER, secureMessages.nextPageNumber()).queryParam(SecureMessageFilter.PAGE_SIZE, secureMessages.getPageSize()).build());
	}

	public void addPreviousLink(SecureMessages secureMessages, URI messagesBaseUri) {
		secureMessages.getLink().addRelatedLink("previous", UriBuilder.fromUri(messagesBaseUri).queryParam(SecureMessageFilter.PAGE_NUMBER, secureMessages.previousPageNumber()).queryParam(SecureMessageFilter.PAGE_SIZE, secureMessages.getPageSize()).build());
	}
}
