package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class SecureMessageContactLinkBuilder extends PatientDataLinkBuilder<SecureMessageContacts, SecureMessageContact> {

	public SecureMessageContactLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(SecureMessageContact dataItem) {
		String userId = dataItem.getPatientId();
		UriBuilder.fromUri(getBaseUri()).path("securemessage-service").path(userId).path("messages").path("id").path(dataItem.getUniqueId()).build();
		return null;
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(SecureMessageContact dataItem) {
		
	}

	@Override
	protected void fillCustomRelatedLinks(SecureMessageContacts dataList) {
		
	}

}
