package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyTest;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyTests;

public class RadiologyTestsLinkBuilder extends PatientDataLinkBuilder<RadiologyTests, RadiologyTest> {

	public RadiologyTestsLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(RadiologyTest dataItem) {
		// URI patientUri = this.extractPatientUri(dataItem);
		// URI selfUri =
		// UriBuilder.fromUri(patientUri).path("radiology").path("test").path("id").path(dataItem.getUniqueId()).build();
		// return selfUri;
		return null;
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return UriBuilder.fromUri(patientUri).path("radiology").path("tests").build();
	}

	@Override
	protected void fillCustomRelatedLinks(RadiologyTest radiologyTest) {
		RadiologyResultsLinkBuilder resultLinkBuilder = new RadiologyResultsLinkBuilder(this.getBaseUri());

		resultLinkBuilder.fillLinks(radiologyTest.getMostRecentRadiologyResult(), null);
		for (RadiologyResult result : radiologyTest.getRadiologyResults()) {
			resultLinkBuilder.fillLinks(result, null);
		}

		URI radiologyResultsUri = resultLinkBuilder.get      icalUriForCollection(this.extractPatientUri(radiologyTest));
		radiologyTest.getLink().addRelatedLink(LinkTitles.PatientRadiologyResults, radiologyResultsUri);
	}

	@Override
	protected void fillCustomRelatedLinks(RadiologyTests dataList) {

	}

}
