package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class RadiologyResultsLinkBuilder extends PatientDataLinkBuilder<RadiologyResults, RadiologyResult> {

	public RadiologyResultsLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(RadiologyResult dataItem) {
		URI patientUri = this.extractPatientUri(dataItem);
		URI selfUri = UriBuilder.fromUri(patientUri).path("radiology").path("results").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(dataItem.getUniqueId()).build();
		return selfUri;
	}

	@Override
	protected void fillCustomRelatedLinks(RadiologyResult dataItem) {
	}

	@Override
	protected void fillCustomRelatedLinks(RadiologyResults dataList) {
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

}
