package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.PropertyDirectory;

public class PropertyDirectoryLinkBuilder {
	private PropertyDirectoryLinkBuilder() {}
	
	public static PropertyDirectory fetchProperties(URI systemBaseUri, URI propertyDirectoryUri) {
		PropertyDirectory directory = new PropertyDirectory();
		
		AtomLink link;
		
		link = new AtomLink();
		link.setHref(propertyDirectoryUri);
		link.setTitle("property-directory");
		directory.getLink().setSelfLink(link);
		
		link = new AtomLink();
		link.setType(MediaType.TEXT_PLAIN);
		link.setHref(UriBuilder.fromUri(systemBaseUri).path("public").path("property-directory").path("notification-option-enabled").build());
		link.setTitle("notification-option-enabled");
		directory.getLink().add(link);
		
		return directory;
	}
}
