package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;

public class ProblemLinkBuilder extends PatientDataLinkBuilder<Problems, Problem> {

	public ProblemLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(Problem dataItem) {
		String domainSpecificPath = "problems";
		URI patientUri = this.extractPatientUri(dataItem);
		return UriBuilder.fromUri(patientUri).path(domainSpecificPath).path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(dataItem.getUniqueId()).build();
	}

	@Override
	protected void fillCustomRelatedLinks(Problem dataItem) {
	}

	@Override
	protected void fillCustomRelatedLinks(Problems dataList) {
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return UriBuilder.fromUri(patientUri).path(getDomainSpecificPath()).build();
	}

	private String getDomainSpecificPath() {
		return "problems";
	}

}
