package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.PatientUriHelper;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriDtoValidator;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriHelper;

public class PatientPreferencesLinkBuilder  {
	private URI baseUri;

	public PatientPreferencesLinkBuilder(URI baseUri) {
		UriDtoValidator.validate(baseUri, "BaseUri is required in order to create patient data links.");
		this.baseUri = baseUri;
	}

	public PatientPreference fillLinks(PatientPreference pref, URI requestUri) {
		if(pref !=null) {
			UriHelper.setSelfUri(pref, requestUri, get      icalSelfUri(pref));
		}
		return pref;
	}

	protected URI getBaseUri() {
		return this.baseUri;
	}
	
	protected URI extractPatientUri(PatientPreference pref) {
		return PatientUriHelper.createPatientSelfUri(pref.getPatientIdentifier(), baseUri);
	}

	protected URI get      icalSelfUri(PatientPreference perf) {
		return UriBuilder.fromUri(extractPatientUri(perf)).path("preference").build();
	}
	
}
