package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;


public class PatientMygoalsLinkBuilder {
	private URI baseUri;

	public PatientMygoalsLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}
	
	public MygoalsList fillLinks(MygoalsList mygoalsList, URI resourceUri) {

		for (Mygoals mygoals : mygoalsList) {
			fillLinks(mygoals, null);
		}
		return mygoalsList;
	}
	
	public MygoalsList fillLatestLinks(MygoalsList mygoalsList, URI resourceUri) {

		for (Mygoals mygoals : mygoalsList) {
			fillLatestMygoalsLinks(mygoals, null);
		}
		return mygoalsList;
	}
	
	private void fillLatestMygoalsLinks(Mygoals mygoals,
			Object object) {
		URI patientUri = getPatientURI(mygoals);	
		mygoals.setSelfUri(UriBuilder.fromUri(patientUri).path(Domain.mygoals).path("latest").build());
	}

	public void fillLinks(Mygoals mygoals, URI resourceUri) {
		setSelfURI(mygoals);
	}

	public void fillFetchLatestLinks(Mygoals mygoals, URI resourceUri) {
		String inventoryType = mygoals.getInventoryType();
		URI patientUri = getPatientURI(mygoals);	
		mygoals.setSelfUri(UriBuilder.fromUri(patientUri).path(Domain.mygoals).path(inventoryType).path("latest").build());
	}
	
	public void fillSaveLinks(Mygoals mygoals, URI resourceUri) {
		if (mygoals != null) {
			String inventoryType = mygoals.getInventoryType();
			URI patientUri = getPatientURI(mygoals);
			mygoals.setSelfUri(UriBuilder.fromUri(patientUri).path(Domain.mygoals).path(inventoryType).path("id").path(mygoals.getId()).build());
		}
	}	
	private void setSelfURI(Mygoals mygoals) {
		mygoals.setSelfUri(computeSelfURI(mygoals));
	}

	private URI computeSelfURI(Mygoals mygoals) {
		String mygoalsId = mygoals.getId();
		URI patientUri =  getPatientURI(mygoals);
		return UriBuilder.fromUri(patientUri).path(Domain.mygoals).path("id").path(mygoalsId).build();
	}

	private URI getPatientURI(Mygoals mygoals) {
		return UriBuilder.fromUri(baseUri).path("patient").path(mygoals.getPatientIdentifier().getAssigningAuthority()).path(mygoals.getPatientIdentifier().getUniqueId()).build();
	}
	
}
