package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;

import javax.ws.rs.core.UriBuilder;
import java.net.URI;

public class PatientEnteredVitalsLinkBuilder extends PatientDataLinkBuilder<VitalEntries, VitalEntry> {

	public PatientEnteredVitalsLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(VitalEntry vitalEntry) {
		URI patientUri = this.extractPatientUri(vitalEntry);
		
		URI selfUri = UriBuilder.fromUri(patientUri).path("patient-entered-vitals").path("system").path(vitalEntry.getSystemId()).path("id").path(vitalEntry.getUniqueId()).build();
		return selfUri;
	}

    @Override
    public void fillLinks(VitalEntries vitalEntries, URI requestUri) {
        super.fillLinks(vitalEntries, requestUri);
        URI pdfUri = UriBuilder.fromUri(requestUri).clone().path("pdf").build();
        vitalEntries.getLink().addRelatedLink("pdf", pdfUri);
    }

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(VitalEntry vitalEntry) {
	}

	@Override
	protected void fillCustomRelatedLinks(VitalEntries vitalEntries) {
	}
}
