package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.PatientUriHelper;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriDtoValidator;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriHelper;

public abstract class PatientDataLinkBuilder<Ts extends PatientDataCollection<T>, T extends PatientData> implements LinkBuilder<Ts, T> {
	private URI baseUri;

	public PatientDataLinkBuilder(URI baseUri) {
		UriDtoValidator.validate(baseUri, "BaseUri is required in order to create patient data links.");
		this.baseUri = baseUri;
	}

	@Override
	public void fillLinks(Ts dataList, URI requestUri) {
		if (dataList != null) {
			UriDtoValidator.validate(dataList);

			dataList.setSelfUri(requestUri);
			fillCustomRelatedLinks(dataList);

			for (T dataItem : dataList) {
				this.fillLinks(dataItem, null);
			}
		}
	}

	@Override
	public void fillLinks(T dataItem, URI requestUri) {
		if (dataItem != null) {
			UriDtoValidator.validate(dataItem);
			UriHelper.setSelfUri(dataItem, requestUri, this.get      icalSelfUri(dataItem));
			fillCustomRelatedLinks(dataItem);
		}
	}

	protected URI getBaseUri() {
		return this.baseUri;
	}

	protected URI extractPatientUri(T dataItem) {
		return PatientUriHelper.createPatientSelfUri(dataItem.getPatientIdentifier(), baseUri);
	}

	public abstract URI get      icalSelfUri(T dataItem);

	public abstract URI get      icalUriForCollection(URI patientUri);

	protected abstract void fillCustomRelatedLinks(T dataItem);

	protected abstract void fillCustomRelatedLinks(Ts dataList);
}
