package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class PatientAssessmentLinkBuilder {
	private URI baseUri;

	public PatientAssessmentLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}

	public Assessments fillLinks(Assessments assessments, PatientIdentifier patientIdentifier, URI resourceUri) {
		for (Assessment assessment : assessments) {
			fillLinks(assessment, patientIdentifier);
		}
		addPainManagementGraphDataRelatedLink(assessments.getLink(), patientIdentifier);
        addPainConsolidatedReportRelatedLink(assessments.getLink(), patientIdentifier);
		return assessments;
	}

    private void addPainConsolidatedReportRelatedLink(AtomLinks links, PatientIdentifier patientIdentifier) {
        URI assessmentsUri = UriBuilder.fromUri(baseUri).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).path("assessments").build();
        links.addRelatedLink(LinkTitles.PatientPainManagementSummaryReport, UriBuilder.fromUri(assessmentsUri).path("painmanagementsummaryreport").build());
    }

    private void addPainManagementGraphDataRelatedLink(AtomLinks links, PatientIdentifier patientIdentifier) {
		URI assessmentsUri = UriBuilder.fromUri(baseUri).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).path("assessments").build();
		links.addRelatedLink(LinkTitles.PatientPainManagementGraphData, UriBuilder.fromUri(assessmentsUri).path("painmanagementgraphdata").build());
	}

	public Assessment fillLinks(Assessment assessment, PatientIdentifier patientIdentifier) {
		URI assessmentUri = UriBuilder.fromUri(baseUri).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).path("assessments").path("id").path(assessment.getId()).build();

		assessment.setSelfUri(assessmentUri);

		assessment.getLink().addRelatedLink(LinkTitles.PatientAssessmentResults, UriBuilder.fromUri(assessmentUri).path("results").build());
		assessment.getLink().addRelatedLink(LinkTitles.PatientAssessmentGraphData, UriBuilder.fromUri(assessmentUri).path("results").path("graphdata").build());
		assessment.getLink().addRelatedLink(LinkTitles.PatientAssessmentEligibility, UriBuilder.fromUri(assessmentUri).path("eligibility").build());
		assessment.getLink().addRelatedLink(LinkTitles.PatientAssessmentDraft, UriBuilder.fromUri(assessmentUri).path("draft").build());

		//although this is not specific to individual assessment, add link for easier use from client
        addPainManagementGraphDataRelatedLink(assessment.getLink(), patientIdentifier);
        addPainConsolidatedReportRelatedLink(assessment.getLink(), patientIdentifier);

		// Sheila hates tool recs
		// so we are leaving it out
		// but it would go here
		// ~~MHP haiku team~~

		return assessment;
	}
}
