package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.NullChecker;

public class PatientAppointmentLinkBuilder extends PatientDataLinkBuilder<Appointments, Appointment> {

	public PatientAppointmentLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(Appointment dataItem) {
		URI patientUri = this.extractPatientUri(dataItem);
		return UriBuilder.fromUri(get      icalUriForCollection(patientUri)).path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(dataItem.getUniqueId()).build();
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return UriBuilder.fromUri(patientUri).path(getDomainSpecificPath()).build();
	}

	private String getDomainSpecificPath() {
		return "appointments";
	}

	@Override
	protected void fillCustomRelatedLinks(Appointment dataItem) {
		if (NullChecker.isNotNullish(dataItem.getClinicVisitId())) {
			URI clinicNoteLink = UriBuilder.fromUri(dataItem.getSelfUri()).path("visit").path(dataItem.getClinicVisitId()).path("note").build();
			dataItem.getLink().addRelatedLink("notes", clinicNoteLink);
		}
	}

	@Override
	protected void fillCustomRelatedLinks(Appointments dataList) {
	}

}
