package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoal;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoals;

public class PainGoalLinkBuilder extends PatientDataLinkBuilder<PainGoals, PainGoal> {
	

	public PainGoalLinkBuilder(URI baseUri) {
		super(baseUri);
	}
	
	@Override
	public URI get      icalSelfUri(PainGoal dataItem) {
		String domainSpecificPath = "pain-goals";
		URI patientUri = this.extractPatientUri(dataItem);
		return UriBuilder.fromUri(patientUri).path(domainSpecificPath).path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(dataItem.getUniqueId()).build();
	}

	@Override
	protected void fillCustomRelatedLinks(PainGoal dataItem) {

		appendRelatedLink(dataItem, "pain-goal-entries", "pain-goal-entries");
	}

	private AtomLink appendRelatedLink(PainGoal painGoal, String uriTitle, String... uriPath) {
		UriBuilder uriBuilder = UriBuilder.fromUri(painGoal.getSelfUri());
		for (String singleUriPath : uriPath) {
			uriBuilder.path(singleUriPath);
		}
		URI uri = uriBuilder.build();
		return appendRelatedLink(painGoal, uriTitle, uri);
	}

	private AtomLink appendRelatedLink(PainGoal painGoal, String uriTitle, URI uri) {
		return painGoal.getLink().addRelatedLink(uriTitle, uri);
	}

	@Override
	protected void fillCustomRelatedLinks(PainGoals dataList) {
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return UriBuilder.fromUri(patientUri).path(getDomainSpecificPath()).build();
	}

	private String getDomainSpecificPath() {
		return "pain-goals";
	}
}
