package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.PainGoalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoalEntry;

public class PainGoalEntryLinkBuilder extends PatientDataLinkBuilder<PainGoalEntries, PainGoalEntry> {

	private String painGoalId;
	
	public PainGoalEntryLinkBuilder(URI baseUri, String painGoalId) {
		
		super(baseUri);
		this.painGoalId = painGoalId;
	}
	
	@Override
	public URI get      icalSelfUri(PainGoalEntry dataItem) {
		String domainSpecificPath = "pain-goals";
		URI patientUri = this.extractPatientUri(dataItem);
		return UriBuilder.fromUri(patientUri).path(domainSpecificPath).path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(painGoalId).path("pain-goal-entries").path("id").path(dataItem.getUniqueId()).build();
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return UriBuilder.fromUri(patientUri).path(getDomainSpecificPath()).build();
	}

	private String getDomainSpecificPath() {
		return "pain-goals";
	}

	
	@Override
	protected void fillCustomRelatedLinks(PainGoalEntry dataItem) {
		
	}

	@Override
	protected void fillCustomRelatedLinks(PainGoalEntries dataList) {
		
	}
}
