package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntry;

public class PainDiaryEntryLinkBuilder extends PatientDataLinkBuilder<PainDiaryEntries, PainDiaryEntry>{

	public PainDiaryEntryLinkBuilder(URI baseUri) {
		super(baseUri);
	}
	
	@Override
	public URI get      icalSelfUri(PainDiaryEntry dataItem) {
		String domainSpecificPath = "pain-diary";
		URI patientUri = this.extractPatientUri(dataItem);
		return UriBuilder.fromUri(patientUri).path(domainSpecificPath).path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(dataItem.getUniqueId()).build();
	}

	@Override
	protected void fillCustomRelatedLinks(PainDiaryEntry dataItem) {
	}

	@Override
	protected void fillCustomRelatedLinks(PainDiaryEntries dataList) {
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return UriBuilder.fromUri(patientUri).path(getDomainSpecificPath()).build();
	}

	private String getDomainSpecificPath() {
		return "pain-diary";
	}

}
