package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.Notification;
import com.agilex.healthcare.mobilehealthplatform.domain.Notifications;

public class NotificationLinkBuilder extends PatientDataLinkBuilder<Notifications, Notification> {

	public NotificationLinkBuilder(URI baseUri) {
		super(baseUri);
	}
	
	@Override
	public URI get      icalSelfUri(Notification dataItem) {
		String encodedUserId = encode(dataItem.getPatientId());
		String encodedNotificationId = encode(dataItem.getNotificationId());
		
		URI selfUri = UriBuilder.fromUri(getBaseUri()).path("notification-service")
				.path(encodedUserId).path("notifications").path(encodedNotificationId).build();
		
		return selfUri;
	}
	
	@Override
	protected void fillCustomRelatedLinks(Notification dataItem) {
	}
	
	@Override
	protected void fillCustomRelatedLinks(Notifications dataList) {
	}
	
	private String encode(String id) {
		String encoded;
		try {
			encoded = URLEncoder.encode(id, "UTF-8");
		} catch (UnsupportedEncodingException failedToEncode) {
			throw new RuntimeException("Could not encode a URL parameter for Notifications");
		}
		return encoded;
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

}
