package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.utility.NullChecker;

public class MicrobiologyLabTestLinkBuilder extends PatientDataLinkBuilder<LabTests, LabTest> {

	public MicrobiologyLabTestLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(LabTest dataItem) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(LabTest labTest) {
		fillResultsForTestLink(labTest);
	}

	private void fillResultsForTestLink(LabTest labTest) {
		URI patientUri = this.extractPatientUri(labTest);
		UriBuilder builder = UriBuilder.fromUri(patientUri).path("lab-microbiology").path("results").queryParam("test-id", labTest.getUniqueId());

		if (containsSpecimen(labTest)) {
			builder = builder.queryParam("specimenId", labTest.getSpecimenId());
		}

		URI uriForResultsForTest = builder.build();
		labTest.getLink().addRelatedLink(LinkTitles.PatientMicrobiologyLabResultsForTest, uriForResultsForTest);
	}

	private boolean containsSpecimen(LabTest labTest) {
		return NullChecker.isNotNullish(labTest.getSpecimenId());
	}

	@Override
	protected void fillCustomRelatedLinks(LabTests dataList) {
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

}
