package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.code.MedicationRefillCode;
import com.agilex.healthcare.utility.NullChecker;

public class MedicationRefillLinkBuilder extends PatientDataLinkBuilder<Medications, Medication> {
	

	public MedicationRefillLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(Medication  medication) {
		URI patientUri = this.extractPatientUri(medication);
		URI selfUri = UriBuilder.fromUri(patientUri).path("medication").path(medication.getUniqueId()).build();
		return selfUri;
	}
	
	@Override
	protected void fillCustomRelatedLinks(Medications medications) {
	}

	@Override
	protected void fillCustomRelatedLinks(Medication medication) {
		URI patientUri = this.extractPatientUri(medication);
		
		// Set Refill Link
		if (NullChecker.isNotNullish(medication.getRefillAction()) && 
			MedicationRefillCode.REFILL_ACTION_ELIGIBLE.equals(medication.getRefillAction())) {
			URI medicationRefillActionUri = UriBuilder.fromUri(patientUri).path("medication-refills").path("refill").build();
			medication.getLink().addRelatedLink(LinkTitles.RelatedMedicationRefills, medicationRefillActionUri);
		}
		
		// Set Details Link
		URI medicationDetailUri = UriBuilder.fromUri(get      icalSelfUri(medication)).path("detail").build();
		medication.setMedicationDetailUri(medicationDetailUri);
	}
	


	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

}
