package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.io.UnsupportedEncodingException;
import java.net.*;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.utility.NullChecker;

public class MedicationLinkBuilder extends PatientDataLinkBuilder<Medications, Medication> {

	public MedicationLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(Medication dataItem) {
		URI patientUri = this.extractPatientUri(dataItem);

		URI selfUri = null;
		if (NullChecker.isNotNullish(dataItem.getUniqueId())) {
			String encodedId;
			try {
				encodedId = URLEncoder.encode(dataItem.getUniqueId(), "UTF-8");
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException("Failed to encode order number", e);
			}

			selfUri = UriBuilder.fromUri(patientUri).path("medications").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedId).build();
		}
		return selfUri;
	}

	@Override
	protected void fillCustomRelatedLinks(Medication dataItem) {
		fillMedicationDetailLink(dataItem);
	}

	private void fillMedicationDetailLink(Medication dataItem) {
		// these were previously separate resources but now are the same. Both
		// are kept for reverse compat
		URI medicationDetailUri = dataItem.getSelfUri();
		dataItem.setMedicationDetailUri(medicationDetailUri);
	}

	@Override
	protected void fillCustomRelatedLinks(Medications dataList) {
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

}
