package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.LearnCondition;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnConditions;

public class LearnConditionLinkBuilder {
	private URI baseUri;

	public LearnConditionLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}

	public void fillLinks(LearnConditions conditions, URI requestUri) {
		conditions.setSelfUri(requestUri);

		for (LearnCondition condition : conditions) {
			URI categoriesByConditionUri = UriBuilder.fromUri(baseUri).path("public").path("learn").path("conditions").path("id").path(condition.getId())
					.path("categories").build();
			conditions.getLink().addRelatedLink(condition.getId(), categoriesByConditionUri);
		}
	}
}
