package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticle;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategory;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnSubCategory;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriHelper;

public class LearnCategoryLinkBuilder {

	private URI baseUri;

	public LearnCategoryLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}

	public void fillLinks(LearnCategories categories, URI requestUri) {
		categories.setSelfUri(requestUri);

		for (LearnCategory category : categories) {
			fillLinks(category, null);
		}
	}

	public void fillLinks(LearnCategory category, URI requestUri) {
		UriHelper.setSelfUri(category, requestUri, this.get      icalSelfUri(category));
		
		for (LearnSubCategory subCategory : category.getSubCategories()) {
			for (LearnArticle article: subCategory.getArticles()) {
				LearnArticleLinkBuilder linkBuilder = new LearnArticleLinkBuilder(baseUri);
				linkBuilder.fillLinks(article, null);
			}
		}
	}

	private URI get      icalSelfUri(LearnCategory category) {
		return UriBuilder.fromUri(baseUri).path("public").path("learn").path("categories").path("id").path(category.getId()).build();
	}

}
