package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticle;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticles;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriHelper;

public class LearnArticleLinkBuilder {

	private URI baseUri;

	public LearnArticleLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}

	public void fillLinks(LearnArticles articles, URI requestUri) {
		articles.setSelfUri(requestUri);

		for (LearnArticle article : articles) {
			fillLinks(article, null);
		}
	}

	public void fillLinks(LearnArticle article, URI requestUri) {
		UriHelper.setSelfUri(article, requestUri, this.get      icalSelfUri(article));
	}

	private URI get      icalSelfUri(LearnArticle article) {
		return UriBuilder.fromUri(baseUri).path("public").path("learn").path("articles").path("id").path(article.getId()).build();
	}
}
