package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequests;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;

public class HealthAdvocateRequestLinkBuilder extends PatientDataLinkBuilder<HealthAdvocateRequests, HealthAdvocateRequest> {

	public HealthAdvocateRequestLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(HealthAdvocateRequest dataItem) {
		URI patientUri = this.extractPatientUri(dataItem);

		String encodedId;
		encodedId = encodeDataId(dataItem);

		URI selfUri = UriBuilder.fromUri(patientUri).path("health-advocate-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedId).build();
		return selfUri;
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(HealthAdvocateRequest dataItem) {
		URI patientUri = this.extractPatientUri(dataItem);
		
		String encodedId = encodeDataId(dataItem);
		
		URI detailFormUri = UriBuilder.fromUri(patientUri).path("health-advocate-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedId).build();
		URI revokedFormUri = UriBuilder.fromUri(patientUri).path("health-advocate-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedId).path("Revoked").build();
		URI cancelledFormUri = UriBuilder.fromUri(patientUri).path("health-advocate-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedId).path("Cancelled").build();

		dataItem.getLink().addRelatedLink(LinkTitles.HealthAdvocateRequestFormDetail, detailFormUri);
		dataItem.getLink().addRelatedLink(LinkTitles.HealthAdvocateRequestRevokedFormDetail, revokedFormUri);
		dataItem.getLink().addRelatedLink(LinkTitles.HealthAdvocateRequestCancelledFormDetail, cancelledFormUri);
	}

	private String encodeDataId(HealthAdvocateRequest dataItem) {
		String encodedId = null;
		try {
			encodedId = URLEncoder.encode(dataItem.getUniqueId(), "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException("Failed to encode order number", e);
		}
		return encodedId;
	}

	@Override
	protected void fillCustomRelatedLinks(HealthAdvocateRequests dataList) {
		
	}

}
