package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.Document;
import com.agilex.healthcare.mobilehealthplatform.domain.Documents;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;

public class DocumentLinkBuilder extends AbstractSimplePatientDataLinkBuilder<Documents, Document> {

	public DocumentLinkBuilder(URI baseUri) {
		super(baseUri);
		this.setIncludeCommunityIn      icalSelfUri(true);
	}

	@Override
	protected String getDomainSpecificPath() {
		return "documents";
	}

	@Override
	protected void fillCustomRelatedLinks(Document dataItem) {
		super.fillCustomRelatedLinks(dataItem);

		URI documentUri = dataItem.getSelfUri();
		URI documentContentUri = UriBuilder.fromUri(documentUri).path("content").build();
		dataItem.getLink().addRelatedLink(LinkTitles.DocumentContent, documentContentUri);
		dataItem.getBody().setSelfUri(documentContentUri);
	}

}
