package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.DietEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.DietEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.PatientUriHelper;

public class DietLinkBuilder extends AbstractSimplePatientDataLinkBuilder<DietEntries, DietEntry> {

	public DietLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	protected String getDomainSpecificPath() {
		return "diet";
	}

	@Override
	protected void fillCustomRelatedLinks(DietEntry mealEntry) {
		URI patientUri = PatientUriHelper.createPatientSelfUri(mealEntry.getPatientIdentifier(), this.getBaseUri());
		URI documentsForDiet = UriBuilder.fromUri(patientUri).path("documents").path("diet").path(mealEntry.getUniqueId()).build();
		mealEntry.getLink().addRelatedLink(LinkTitles.RelatedDocuments, documentsForDiet);
	}

	@Override
	protected boolean shouldIncludeCommunityIn      icalSelfUri() {
		return true;
	}

}
