package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.PatientUriHelper;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriDtoValidator;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriHelper;

public class DemographicsLinkBuilder {
	private URI baseUri;

	public DemographicsLinkBuilder(URI baseUri) {
		UriDtoValidator.validate(baseUri, "BaseUri is required in order to create patient data links.");
		this.baseUri = baseUri;
	}

	public void fillLinks(PatientDemographics demographics, URI requestUri) {
		if (demographics != null) {
			UriHelper.setSelfUri(demographics, requestUri, get      icalSelfUri(demographics));
		}
	}

	protected URI getBaseUri() {
		return this.baseUri;
	}

	protected URI extractPatientUri(PatientDemographics demographics) {
		return PatientUriHelper.createPatientSelfUri(demographics.getPatientIdentifier(), baseUri);
	}

	protected URI get      icalSelfUri(PatientDemographics demographics) {
		return UriBuilder.fromUri(extractPatientUri(demographics)).path("demographics").build();
	}

}
